/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.test;

import com.orientechnologies.lucene.test.BaseLuceneTest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.script.OCommandScript;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.io.InputStream;
import java.util.List;
import org.apache.lucene.analysis.en.EnglishAnalyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class LuceneMultiFieldTest
extends BaseLuceneTest {
    @Before
    public void init() {
        InputStream stream = ClassLoader.getSystemResourceAsStream("testLuceneIndex.sql");
        this.db.command((OCommandRequest)new OCommandScript("sql", this.getScriptFromStream(stream))).execute(new Object[0]);
        this.db.command((OCommandRequest)new OCommandSQL("create index Song.title_author on Song (title,author) FULLTEXT ENGINE LUCENE METADATA {\"title_index\":\"" + EnglishAnalyzer.class.getName() + "\" , \"title_query\":\"" + EnglishAnalyzer.class.getName() + "\" , \"author_index\":\"" + StandardAnalyzer.class.getName() + "\"}")).execute(new Object[0]);
        ODocument index = this.db.getMetadata().getIndexManager().getIndex("Song.title_author").getMetadata();
        Assertions.assertThat((Object)index.field("author_index")).isEqualTo((Object)StandardAnalyzer.class.getName());
        Assertions.assertThat((Object)index.field("title_index")).isEqualTo((Object)EnglishAnalyzer.class.getName());
    }

    @Test
    public void testSelectSingleDocumentWithAndOperator() {
        List docs = this.db.query((OQuery)new OSQLSynchQuery("select * from Song where [title,author] LUCENE \"(title:mountain AND author:Fabbio)\""), new Object[0]);
        Assertions.assertThat((List)docs).hasSize(1);
    }

    @Test
    public void testSelectSingleDocumentWithAndOperatorNEwExec() {
        OResultSet docs = this.db.query("select * from Song where [title,author] LUCENE \"(title:mountain AND author:Fabbio)\"", new Object[0]);
        Assertions.assertThat((boolean)docs.hasNext()).isTrue();
        docs.next();
        Assertions.assertThat((boolean)docs.hasNext()).isFalse();
    }

    @Test
    public void testSelectMultipleDocumentsWithOrOperator() {
        List docs = this.db.query((OQuery)new OSQLSynchQuery("select * from Song where [title,author] LUCENE \"(title:mountain OR author:Fabbio)\""), new Object[0]);
        Assertions.assertThat((List)docs).hasSize(91);
    }

    @Test
    public void testSelectOnTitleAndAuthorWithMatchOnTitle() {
        List docs = this.db.query((OQuery)new OSQLSynchQuery("select * from Song where [title,author] LUCENE \"mountain\""), new Object[0]);
        Assertions.assertThat((List)docs).hasSize(5);
    }

    @Test
    public void testSelectOnTitleAndAuthorWithMatchOnAuthor() {
        List docs = this.db.query((OQuery)new OSQLSynchQuery("select * from Song where [title,author] LUCENE \"author:fabbio\""), new Object[0]);
        Assertions.assertThat((List)docs).hasSize(87);
    }

    @Test
    @Ignore
    public void testSelectOnAuthorWithMatchOnAuthor() {
        List docs = this.db.query((OQuery)new OSQLSynchQuery("select * from Song where [author,title] LUCENE \"(fabbio)\""), new Object[0]);
        Assertions.assertThat((List)docs).hasSize(87);
    }

    @Test
    public void testSelectOnIndexWithIgnoreNullValuesToFalse() {
        String script = "create class Item\ncreate property Item.Title string\ncreate property Item.Summary string\ncreate property Item.Content string\ncreate index Item.i_lucene on Item(Title, Summary, Content) fulltext engine lucene METADATA {ignoreNullValues:false}\ninsert into Item set Title = 'wrong', content = 'not me please'\ninsert into Item set Title = 'test', content = 'this is a test'\n";
        this.db.command((OCommandRequest)new OCommandScript("sql", script)).execute(new Object[0]);
        List docs = this.db.query((OQuery)new OSQLSynchQuery("select * from Item where Title lucene 'te*'"), new Object[0]);
        Assertions.assertThat((List)docs).hasSize(1);
        docs = this.db.query((OQuery)new OSQLSynchQuery("select * from Item where [Title, Summary, Content] lucene 'test'"), new Object[0]);
        Assertions.assertThat((List)docs).hasSize(1);
        docs = this.db.query((OQuery)new OSQLSynchQuery(" SELECT expand(rid) FROM index:Item.i_lucene where key = \"(Title:test )\""), new Object[0]);
        Assertions.assertThat((List)docs).hasSize(1);
    }
}

