/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.test;

import com.orientechnologies.lucene.test.BaseLuceneTest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.script.OCommandScript;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.io.InputStream;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LuceneMixIndexTest
extends BaseLuceneTest {
    @Before
    public void initLocal() {
        InputStream stream = ClassLoader.getSystemResourceAsStream("testLuceneIndex.sql");
        this.db.command((OCommandRequest)new OCommandScript("sql", this.getScriptFromStream(stream))).execute(new Object[0]);
        this.db.command((OCommandRequest)new OCommandSQL("create index Song.author on Song (author) NOTUNIQUE")).execute(new Object[0]);
        this.db.command((OCommandRequest)new OCommandSQL("create index Song.composite on Song (title,lyrics) FULLTEXT ENGINE LUCENE")).execute(new Object[0]);
    }

    @Test
    public void testMixQuery() {
        List docs = this.db.query((OQuery)new OSQLSynchQuery("select * from Song where  author = 'Hornsby' and [title,lyrics]  LUCENE \"(title:mountain)\" "), new Object[0]);
        Assert.assertEquals((long)1L, (long)docs.size());
        docs = this.db.query((OQuery)new OSQLSynchQuery("select * from Song where  author = 'Hornsby' and [title,lyrics] LUCENE \"(title:mountain)\" "), new Object[0]);
        Assert.assertEquals((long)1L, (long)docs.size());
        docs = this.db.query((OQuery)new OSQLSynchQuery("select * from Song where  author = 'Hornsby' and [title,lyrics] LUCENE \"(title:ballad)\" "), new Object[0]);
        Assert.assertEquals((long)0L, (long)docs.size());
        docs = this.db.query((OQuery)new OSQLSynchQuery("select * from Song where  author = 'Hornsby' and [title,lyrics] LUCENE \"(title:ballad)\" "), new Object[0]);
        Assert.assertEquals((long)0L, (long)docs.size());
    }

    @Test
    public void testMixCompositeQuery() {
        List docs = this.db.query((OQuery)new OSQLSynchQuery("select * from Song where  author = 'Hornsby' and [title,lyrics] LUCENE \"title:mountain\" "), new Object[0]);
        Assert.assertEquals((long)1L, (long)docs.size());
        docs = this.db.query((OQuery)new OSQLSynchQuery("select * from Song where author = 'Hornsby' and [title,lyrics] LUCENE \"lyrics:happy\" "), new Object[0]);
        Assert.assertEquals((long)1L, (long)docs.size());
    }
}

