/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.test;

import com.orientechnologies.lucene.test.BaseLuceneTest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.OVertex;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class LuceneMiscTest
extends BaseLuceneTest {
    public void testDoubleLucene() {
        this.db.command((OCommandRequest)new OCommandSQL("create class Test extends V")).execute(new Object[0]);
        this.db.command((OCommandRequest)new OCommandSQL("create property Test.attr1 string")).execute(new Object[0]);
        this.db.command((OCommandRequest)new OCommandSQL("create index Test.attr1 on Test (attr1) fulltext engine lucene")).execute(new Object[0]);
        this.db.command((OCommandRequest)new OCommandSQL("create property Test.attr2 string")).execute(new Object[0]);
        this.db.command((OCommandRequest)new OCommandSQL("create index Test.attr2 on Test (attr2) fulltext engine lucene")).execute(new Object[0]);
        this.db.command((OCommandRequest)new OCommandSQL("insert into Test set attr1='foo', attr2='bar'")).execute(new Object[0]);
        this.db.command((OCommandRequest)new OCommandSQL("insert into Test set attr1='bar', attr2='foo'")).execute(new Object[0]);
        List results = (List)this.db.command((OCommandRequest)new OCommandSQL("select from Test where attr1 lucene 'foo*' OR attr2 lucene 'foo*'")).execute(new Object[0]);
        Assert.assertEquals((long)2L, (long)results.size());
        results = (List)this.db.command((OCommandRequest)new OCommandSQL("select from Test where attr1 lucene 'bar*' OR attr2 lucene 'bar*'")).execute(new Object[0]);
        Assert.assertEquals((long)2L, (long)results.size());
        results = (List)this.db.command((OCommandRequest)new OCommandSQL("select from Test where attr1 lucene 'foo*' AND attr2 lucene 'bar*'")).execute(new Object[0]);
        Assert.assertEquals((long)1L, (long)results.size());
        results = (List)this.db.command((OCommandRequest)new OCommandSQL("select from Test where attr1 lucene 'bar*' AND attr2 lucene 'foo*'")).execute(new Object[0]);
        Assert.assertEquals((long)1L, (long)results.size());
    }

    @Test
    public void testSubLucene() {
        this.db.command((OCommandRequest)new OCommandSQL("create class Person extends V")).execute(new Object[0]);
        this.db.command((OCommandRequest)new OCommandSQL("create property Person.name string")).execute(new Object[0]);
        this.db.command((OCommandRequest)new OCommandSQL("create index Person.name on Person (name) fulltext engine lucene")).execute(new Object[0]);
        this.db.command((OCommandRequest)new OCommandSQL("insert into Person set name='Enrico', age=18")).execute(new Object[0]);
        OSQLSynchQuery query = new OSQLSynchQuery("select  from (select from Person where age = 18) where name lucene 'Enrico'");
        List results = (List)this.db.command((OCommandRequest)query).execute(new Object[0]);
        Assert.assertEquals((long)1L, (long)results.size());
        query = new OSQLSynchQuery("select  from (select name  from Person where age = 18) where name lucene 'Enrico'");
        results = (List)this.db.command((OCommandRequest)query).execute(new Object[0]);
        Assert.assertEquals((long)0L, (long)results.size());
    }

    @Test
    public void testNamedParams() {
        this.db.command((OCommandRequest)new OCommandSQL("create class Test extends V")).execute(new Object[0]);
        this.db.command((OCommandRequest)new OCommandSQL("create property Test.attr1 string")).execute(new Object[0]);
        this.db.command((OCommandRequest)new OCommandSQL("create index Test.attr1 on Test (attr1) fulltext engine lucene")).execute(new Object[0]);
        this.db.command((OCommandRequest)new OCommandSQL("insert into Test set attr1='foo', attr2='bar'")).execute(new Object[0]);
        OSQLSynchQuery query = new OSQLSynchQuery("select from Test where attr1 lucene :name");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", "FOO or");
        List results = (List)this.db.command((OCommandRequest)query).execute(new Object[]{params});
        Assert.assertEquals((long)1L, (long)results.size());
    }

    @Test
    public void dottedNotationTest() {
        OSchema schema = this.db.getMetadata().getSchema();
        OClass v = schema.getClass("V");
        OClass e = schema.getClass("E");
        OClass author = schema.createClass("Author", v);
        author.createProperty("name", OType.STRING);
        OClass song = schema.createClass("Song", v);
        song.createProperty("title", OType.STRING);
        OClass authorOf = schema.createClass("AuthorOf", e);
        authorOf.createProperty("in", OType.LINK, song);
        this.db.commit();
        this.db.command((OCommandRequest)new OCommandSQL("create index AuthorOf.in on AuthorOf (in) NOTUNIQUE")).execute(new Object[0]);
        this.db.command((OCommandRequest)new OCommandSQL("create index Song.title on Song (title) FULLTEXT ENGINE LUCENE")).execute(new Object[0]);
        OVertex authorVertex = this.db.newVertex("Author");
        authorVertex.setProperty("name", (Object)"Bob Dylan");
        this.db.save((ORecord)authorVertex);
        OVertex songVertex = this.db.newVertex("Song");
        songVertex.setProperty("title", (Object)"hurricane");
        this.db.save((ORecord)songVertex);
        OEdge edge = authorVertex.addEdge(songVertex, "AuthorOf");
        this.db.save((ORecord)edge);
        List results = (List)this.db.command((OCommandRequest)new OCommandSQL("select from AuthorOf")).execute(new Object[0]);
        Assert.assertEquals((long)results.size(), (long)1L);
        results = (List)this.db.command((OCommandRequest)new OCommandSQL("select from AuthorOf where in.title lucene 'hurricane'")).execute(new Object[0]);
        System.out.println("results = " + results);
        Assert.assertEquals((long)results.size(), (long)1L);
    }

    @Test
    public void testUnderscoreField() {
        this.db.command((OCommandRequest)new OCommandSQL("create class Test extends V")).execute(new Object[0]);
        this.db.command((OCommandRequest)new OCommandSQL("create property V._attr1 string")).execute(new Object[0]);
        this.db.command((OCommandRequest)new OCommandSQL("create index V._attr1 on V (_attr1) fulltext engine lucene")).execute(new Object[0]);
        this.db.command((OCommandRequest)new OCommandSQL("insert into Test set _attr1='anyPerson', attr2='bar'")).execute(new Object[0]);
        OSQLSynchQuery query = new OSQLSynchQuery("select from Test where _attr1 lucene :name");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", "anyPerson");
        List results = (List)this.db.command((OCommandRequest)query).execute(new Object[]{params});
        Assert.assertEquals((long)results.size(), (long)1L);
    }
}

