/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.test;

import com.orientechnologies.lucene.test.BaseLuceneTest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LuceneMassiveInsertDeleteTest
extends BaseLuceneTest {
    @Before
    public void init() {
        OSchema schema = this.db.getMetadata().getSchema();
        OClass v = schema.getClass("V");
        OClass song = schema.createClass("City");
        song.setSuperClass(v);
        song.createProperty("name", OType.STRING);
        this.db.command((OCommandRequest)new OCommandSQL("create index City.name on City (name) FULLTEXT ENGINE LUCENE")).execute(new Object[0]);
    }

    @Test
    public void loadCloseDelete() {
        int size = 1000;
        for (int i = 0; i < size; ++i) {
            ODocument city = new ODocument("City");
            city.field("name", (Object)("Rome " + i));
            this.db.save((ORecord)city);
        }
        String query = "select * from City where name LUCENE 'name:Rome'";
        List docs = this.db.query((OQuery)new OSQLSynchQuery(query), new Object[0]);
        Assert.assertEquals((long)docs.size(), (long)size);
        this.db.close();
        this.db.open("admin", "admin");
        docs = this.db.query((OQuery)new OSQLSynchQuery(query), new Object[0]);
        Assert.assertEquals((long)docs.size(), (long)size);
        this.db.command((OCommandRequest)new OCommandSQL("delete vertex City")).execute(new Object[0]);
        docs = this.db.query((OQuery)new OSQLSynchQuery(query), new Object[0]);
        Assert.assertEquals((long)docs.size(), (long)0L);
        this.db.close();
        this.db.open("admin", "admin");
        docs = this.db.query((OQuery)new OSQLSynchQuery(query), new Object[0]);
        Assert.assertEquals((long)docs.size(), (long)0L);
        this.db.getMetadata().reload();
        OIndex idx = this.db.getMetadata().getSchema().getClass("City").getClassIndex("City.name");
        idx.flush();
        Assert.assertEquals((long)idx.getSize(), (long)1L);
    }
}

