/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.test;

import com.orientechnologies.lucene.test.BaseLuceneTest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OSimpleKeyIndexDefinition;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.util.List;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LuceneManualIndexTest
extends BaseLuceneTest {
    @Before
    public void init() {
        this.db.command((OCommandRequest)new OCommandSQL("create index manual FULLTEXT ENGINE LUCENE STRING,STRING")).execute(new Object[0]);
        this.db.command((OCommandRequest)new OCommandSQL("insert into index:manual (key,rid) values(['Enrico','London'],#5:0) ")).execute(new Object[0]);
        this.db.command((OCommandRequest)new OCommandSQL("insert into index:manual (key,rid) values(['Luca','Rome'],#5:0) ")).execute(new Object[0]);
        this.db.command((OCommandRequest)new OCommandSQL("insert into index:manual (key,rid) values(['Luigi','Rome'],#5:0) ")).execute(new Object[0]);
    }

    @Test
    public void shouldCreateManualIndexWithJavaApi() throws Exception {
        ODocument meta = new ODocument().field("analyzer", (Object)StandardAnalyzer.class.getName());
        OIndex index = this.db.getMetadata().getIndexManager().createIndex("apiManual", OClass.INDEX_TYPE.FULLTEXT.toString(), (OIndexDefinition)new OSimpleKeyIndexDefinition(1, new OType[]{OType.STRING, OType.STRING}), null, null, meta, "LUCENE");
        this.db.command((OCommandRequest)new OCommandSQL("insert into index:apiManual (key,rid) values(['Enrico','London'],#5:0) ")).execute(new Object[0]);
        this.db.command((OCommandRequest)new OCommandSQL("insert into index:apiManual (key,rid) values(['Luca','Rome'],#5:0) ")).execute(new Object[0]);
        this.db.command((OCommandRequest)new OCommandSQL("insert into index:apiManual (key,rid) values(['Luigi','Rome'],#5:0) ")).execute(new Object[0]);
        Assert.assertEquals((long)index.getSize(), (long)4L);
        List docs = (List)this.db.command((OCommandRequest)new OSQLSynchQuery("select from index:apiManual where key LUCENE '(k0:Enrico)'")).execute(new Object[0]);
        Assert.assertEquals((long)docs.size(), (long)1L);
        docs = (List)this.db.command((OCommandRequest)new OSQLSynchQuery("select from index:apiManual where key LUCENE '(k0:Luca)'")).execute(new Object[0]);
        Assert.assertEquals((long)docs.size(), (long)1L);
        docs = (List)this.db.command((OCommandRequest)new OSQLSynchQuery("select from index:apiManual where key LUCENE '(k1:Rome)'")).execute(new Object[0]);
        Assert.assertEquals((long)docs.size(), (long)2L);
        docs = (List)this.db.command((OCommandRequest)new OSQLSynchQuery("select from index:apiManual where key LUCENE '(k1:London)'")).execute(new Object[0]);
        Assert.assertEquals((long)docs.size(), (long)1L);
    }

    @Test
    public void testManualIndex() {
        OIndex manual = this.db.getMetadata().getIndexManager().getIndex("manual");
        Assert.assertEquals((long)manual.getSize(), (long)4L);
        List docs = (List)this.db.command((OCommandRequest)new OSQLSynchQuery("select from index:manual where key LUCENE 'Enrico'")).execute(new Object[0]);
        Assert.assertEquals((long)docs.size(), (long)1L);
    }

    @Test
    public void testManualIndexWitKeys() {
        OIndex manual = this.db.getMetadata().getIndexManager().getIndex("manual");
        Assert.assertEquals((long)manual.getSize(), (long)4L);
        List docs = (List)this.db.command((OCommandRequest)new OSQLSynchQuery("select from index:manual where key LUCENE '(k0:Enrico)'")).execute(new Object[0]);
        Assert.assertEquals((long)docs.size(), (long)1L);
        docs = (List)this.db.command((OCommandRequest)new OSQLSynchQuery("select from index:manual where key LUCENE '(k0:Luca)'")).execute(new Object[0]);
        Assert.assertEquals((long)docs.size(), (long)1L);
        docs = (List)this.db.command((OCommandRequest)new OSQLSynchQuery("select from index:manual where key LUCENE '(k1:Rome)'")).execute(new Object[0]);
        Assert.assertEquals((long)docs.size(), (long)2L);
        docs = (List)this.db.command((OCommandRequest)new OSQLSynchQuery("select from index:manual where key LUCENE '(k1:London)'")).execute(new Object[0]);
        Assert.assertEquals((long)docs.size(), (long)1L);
    }

    @Test
    public void testManualIndexInsideTransaction() throws Exception {
        OIndex index = this.db.getMetadata().getIndexManager().createIndex("test", OClass.INDEX_TYPE.FULLTEXT.toString(), (OIndexDefinition)new OSimpleKeyIndexDefinition(1, new OType[]{OType.STRING}), null, null, null, "LUCENE");
        this.db.begin();
        ODocument document = this.db.newInstance();
        document.field("name", (Object)"Rob");
        this.db.save((ORecord)document, this.db.getClusterNameById(this.db.getDefaultClusterId()));
        index.put((Object)"Rob", (OIdentifiable)document.getIdentity());
        index.flush();
        List docs = (List)this.db.command((OCommandRequest)new OSQLSynchQuery("select from index:test where key LUCENE 'k0:rob'")).execute(new Object[0]);
        Assert.assertEquals((long)docs.size(), (long)1L);
        this.db.commit();
    }
}

