/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.test;

import com.orientechnologies.lucene.test.BaseLuceneTest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.OVertex;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class LuceneListIndexingTest
extends BaseLuceneTest {
    @Before
    public void init() {
        OSchema schema = this.db.getMetadata().getSchema();
        OClass person = schema.createClass("Person");
        person.createProperty("name", OType.STRING);
        person.createProperty("tags", OType.EMBEDDEDLIST, OType.STRING);
        this.db.command((OCommandRequest)new OCommandSQL("create index Person.name_tags on Person (name,tags) FULLTEXT ENGINE LUCENE")).execute(new Object[0]);
        OClass city = schema.createClass("City");
        city.createProperty("name", OType.STRING);
        city.createProperty("tags", OType.EMBEDDEDLIST, OType.STRING);
        this.db.command((OCommandRequest)new OCommandSQL("create index City.tags on City (tags) FULLTEXT ENGINE LUCENE")).execute(new Object[0]);
    }

    @Test
    public void testIndexingList() throws Exception {
        OSchema schema = this.db.getMetadata().getSchema();
        ODocument doc = new ODocument("City");
        doc.field("name", (Object)"Rome");
        doc.field("tags", (Object)new ArrayList<String>(){
            {
                this.add("Beautiful");
                this.add("Touristic");
                this.add("Sunny");
            }
        });
        this.db.save((ORecord)doc);
        OIndex tagsIndex = schema.getClass("City").getClassIndex("City.tags");
        Collection coll = (Collection)tagsIndex.get((Object)"Sunny");
        Assertions.assertThat((Iterable)coll).hasSize(1);
        doc = (ODocument)this.db.load((ORID)coll.iterator().next());
        Assertions.assertThat((String)((String)doc.field("name"))).isEqualTo((Object)"Rome");
        doc = new ODocument("City");
        doc.field("name", (Object)"London");
        doc.field("tags", (Object)new ArrayList<String>(){
            {
                this.add("Beautiful");
                this.add("Touristic");
                this.add("Sunny");
            }
        });
        this.db.save((ORecord)doc);
        coll = (Collection)tagsIndex.get((Object)"Sunny");
        Assertions.assertThat((Iterable)coll).hasSize(2);
        List tags = (List)doc.field("tags");
        tags.remove("Sunny");
        tags.add("Rainy");
        this.db.save((ORecord)doc);
        coll = (Collection)tagsIndex.get((Object)"Rainy");
        Assertions.assertThat((Iterable)coll).hasSize(1);
        coll = (Collection)tagsIndex.get((Object)"Beautiful");
        Assertions.assertThat((Iterable)coll).hasSize(2);
        coll = (Collection)tagsIndex.get((Object)"Sunny");
        Assertions.assertThat((Iterable)coll).hasSize(1);
    }

    @Test
    public void testCompositeIndexList() {
        OSchema schema = this.db.getMetadata().getSchema();
        ODocument doc = new ODocument("Person");
        doc.field("name", (Object)"Enrico");
        doc.field("tags", (Object)new ArrayList<String>(){
            {
                this.add("Funny");
                this.add("Tall");
                this.add("Geek");
            }
        });
        this.db.save((ORecord)doc);
        OIndex idx = schema.getClass("Person").getClassIndex("Person.name_tags");
        Collection coll = (Collection)idx.get((Object)"Enrico");
        Assertions.assertThat((Iterable)coll).hasSize(3);
        doc = new ODocument("Person");
        doc.field("name", (Object)"Jared");
        doc.field("tags", (Object)new ArrayList<String>(){
            {
                this.add("Funny");
                this.add("Tall");
            }
        });
        this.db.save((ORecord)doc);
        coll = (Collection)idx.get((Object)"Jared");
        Assertions.assertThat((Iterable)coll).hasSize(2);
        List tags = (List)doc.field("tags");
        tags.remove("Funny");
        tags.add("Geek");
        this.db.save((ORecord)doc);
        coll = (Collection)idx.get((Object)"Funny");
        Assertions.assertThat((Iterable)coll).hasSize(1);
        coll = (Collection)idx.get((Object)"Geek");
        Assertions.assertThat((Iterable)coll).hasSize(2);
        List query = this.db.query((OQuery)new OSQLSynchQuery("select from Person where [name,tags] lucene 'Enrico'"), new Object[0]);
        Assertions.assertThat((List)query).hasSize(1);
        query = this.db.query((OQuery)new OSQLSynchQuery("select from (select from Person where [name,tags] lucene 'Enrico')"), new Object[0]);
        Assertions.assertThat((List)query).hasSize(1);
        query = this.db.query((OQuery)new OSQLSynchQuery("select from Person where [name,tags] lucene 'Jared'"), new Object[0]);
        Assertions.assertThat((List)query).hasSize(1);
        query = this.db.query((OQuery)new OSQLSynchQuery("select from Person where [name,tags] lucene 'Funny'"), new Object[0]);
        Assertions.assertThat((List)query).hasSize(1);
        query = this.db.query((OQuery)new OSQLSynchQuery("select from Person where [name,tags] lucene 'Geek'"), new Object[0]);
        Assertions.assertThat((List)query).hasSize(2);
        query = this.db.query((OQuery)new OSQLSynchQuery("select from Person where [name,tags] lucene '(name:Enrico AND tags:Geek)'"), new Object[0]);
        Assertions.assertThat((List)query).hasSize(1);
    }

    @Test
    public void rname() throws Exception {
        OClass c1 = this.db.createVertexClass("C1");
        c1.createProperty("p1", OType.STRING);
        ODocument metadata = new ODocument();
        metadata.field("default", (Object)"org.apache.lucene.analysis.en.EnglishAnalyzer");
        c1.createIndex("p1", "FULLTEXT", null, metadata, "LUCENE", new String[]{"p1"});
        OVertex vertex = this.db.newVertex("C1");
        vertex.setProperty("p1", (Object)"testing");
        this.db.save((ORecord)vertex);
        this.db.commit();
        List search = this.db.query((OQuery)new OSQLSynchQuery("SELECT from C1 WHERE p1 LUCENE \"tested\""), new Object[0]);
        Assertions.assertThat((List)search).hasSize(1);
    }
}

