/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.test;

import com.orientechnologies.lucene.test.BaseLuceneTest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.script.OCommandScript;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.io.InputStream;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class LuceneIssuesTest
extends BaseLuceneTest {
    @Test
    public void testGh_7382() throws Exception {
        InputStream stream = ClassLoader.getSystemResourceAsStream("testGh_7382.osql");
        this.db.command((OCommandRequest)new OCommandScript("sql", this.getScriptFromStream(stream))).execute(new Object[0]);
        List results = this.db.query((OQuery)new OSQLSynchQuery("select server,date from index:class_7382_multi WHERE key = 'server:206012226875414 AND date:[201703120000 TO  201703120001]' "), new Object[0]);
        Assertions.assertThat((List)results).hasSize(1);
    }

    @Test
    public void testGh_4880_moreIndexesOnProperty() throws Exception {
        InputStream stream = ClassLoader.getSystemResourceAsStream("testLuceneIndex.sql");
        this.db.command((OCommandRequest)new OCommandScript("sql", this.getScriptFromStream(stream))).execute(new Object[0]);
        this.db.command((OCommandRequest)new OCommandSQL("create index Song.title_ft on Song (title,author) FULLTEXT ENGINE LUCENE")).execute(new Object[0]);
        this.db.command((OCommandRequest)new OCommandSQL("CREATE INDEX Song.author on Song (author)  NOTUNIQUE")).execute(new Object[0]);
        this.db.query((OQuery)new OSQLSynchQuery("SELECT from Song where title = 'BELIEVE IT OR NOT' "), new Object[0]);
        ODocument query = (ODocument)this.db.command((OCommandRequest)new OCommandSQL("EXPLAIN SELECT from Song where author = 'Traditional'  OR ['title','author'] LUCENE 'title:believe'")).execute(new Object[0]);
    }

    @Test
    public void testGh_issue7513() throws Exception {
        InputStream stream = ClassLoader.getSystemResourceAsStream("testGh_7513.osql");
        this.db.command((OCommandRequest)new OCommandScript("sql", this.getScriptFromStream(stream))).execute(new Object[0]);
        List documents = this.db.query((OQuery)new OSQLSynchQuery("select rid from index:Item.content where key lucene '\u0425\u0430\u0440\u044c\u043a\u043e~0.2' limit 3 "), new Object[0]);
        Assertions.assertThat((List)documents).hasSize(3);
        documents = this.db.query((OQuery)new OSQLSynchQuery("select expand(rid) from index:Item.content where key lucene '\u0425\u0430\u0440\u044c\u043a\u043e~0.2' limit 3 "), new Object[0]);
        Assertions.assertThat((List)documents).hasSize(3);
        documents = this.db.query((OQuery)new OSQLSynchQuery("select * from index:Item.content where key lucene '\u0425\u0430\u0440\u044c\u043a\u043e~0.2' limit 3 "), new Object[0]);
        Assertions.assertThat((List)documents).hasSize(3);
    }

    @Test
    public void test_ph8929() throws Exception {
        InputStream stream = ClassLoader.getSystemResourceAsStream("testPh_8929.osql");
        this.db.command((OCommandRequest)new OCommandScript("sql", this.getScriptFromStream(stream))).execute(new Object[0]);
        List documents = this.db.query((OQuery)new OSQLSynchQuery("select from Test where [a] lucene 'lion'"), new Object[0]);
        Assertions.assertThat((List)documents).hasSize(1);
        documents = this.db.query((OQuery)new OSQLSynchQuery("select from Test where [b] lucene 'mouse'"), new Object[0]);
        Assertions.assertThat((List)documents).hasSize(1);
        documents = this.db.query((OQuery)new OSQLSynchQuery("select from Test where [a] lucene 'lion' OR [b] LUCENE 'mouse' "), new Object[0]);
        Assertions.assertThat((List)documents).hasSize(2);
    }

    @Test
    public void test_ph8929_Single() throws Exception {
        InputStream stream = ClassLoader.getSystemResourceAsStream("testPh_8929.osql");
        this.db.command((OCommandRequest)new OCommandScript("sql", this.getScriptFromStream(stream))).execute(new Object[0]);
        List documents = this.db.query((OQuery)new OSQLSynchQuery("select from Test where a lucene 'lion'"), new Object[0]);
        Assertions.assertThat((List)documents).hasSize(1);
        documents = this.db.query((OQuery)new OSQLSynchQuery("select from Test where b lucene 'mouse'"), new Object[0]);
        Assertions.assertThat((List)documents).hasSize(1);
        documents = this.db.query((OQuery)new OSQLSynchQuery("select from Test where a lucene 'lion' OR b LUCENE 'mouse' "), new Object[0]);
        Assertions.assertThat((List)documents).hasSize(2);
    }
}

