/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.test;

import com.orientechnologies.lucene.test.BaseLuceneTest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LuceneInsertUpdateSingleDocumentTransactionTest
extends BaseLuceneTest {
    @Before
    public void init() {
        OSchema schema = this.db.getMetadata().getSchema();
        OClass oClass = schema.createClass("City");
        oClass.createProperty("name", OType.STRING);
        this.db.command((OCommandRequest)new OCommandSQL("create index City.name on City (name) FULLTEXT ENGINE LUCENE")).execute(new Object[0]);
    }

    @Test
    public void testInsertUpdateTransactionWithIndex() throws Exception {
        this.db.close();
        this.db.open("admin", "admin");
        OSchema schema = this.db.getMetadata().getSchema();
        schema.reload();
        this.db.begin();
        ODocument doc = new ODocument("City");
        doc.field("name", (Object)"");
        ODocument doc1 = new ODocument("City");
        doc1.field("name", (Object)"");
        doc = (ODocument)this.db.save((ORecord)doc);
        doc1 = (ODocument)this.db.save((ORecord)doc1);
        this.db.commit();
        this.db.begin();
        doc = (ODocument)this.db.load((ORecord)doc);
        doc1 = (ODocument)this.db.load((ORecord)doc1);
        doc.field("name", (Object)"Rome");
        doc1.field("name", (Object)"Rome");
        this.db.save((ORecord)doc);
        this.db.save((ORecord)doc1);
        this.db.commit();
        OIndex idx = schema.getClass("City").getClassIndex("City.name");
        Collection coll = (Collection)idx.get((Object)"Rome");
        Assert.assertEquals((long)coll.size(), (long)2L);
        Assert.assertEquals((long)3L, (long)idx.getSize());
    }
}

