/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.test;

import com.orientechnologies.lucene.test.BaseLuceneTest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.intent.OIntent;
import com.orientechnologies.orient.core.intent.OIntentMassiveInsert;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LuceneInsertReadMultithreadTest
extends BaseLuceneTest {
    private static final int THREADS = 10;
    private static final int RTHREADS = 1;
    private static final int CYCLE = 100;
    protected String url = "";

    @Before
    public void init() {
        this.url = this.db.getURL();
        OSchema schema = this.db.getMetadata().getSchema();
        OClass oClass = schema.createClass("City");
        oClass.createProperty("name", OType.STRING);
        this.db.command((OCommandRequest)new OCommandSQL("create index City.name on City (name) FULLTEXT ENGINE LUCENE")).execute(new Object[0]);
    }

    @Test
    public void testConcurrentInsertWithIndex() throws Exception {
        int i;
        this.db.getMetadata().reload();
        OSchema schema = this.db.getMetadata().getSchema();
        Thread[] threads = new Thread[11];
        for (i = 0; i < 10; ++i) {
            threads[i] = new Thread((Runnable)new LuceneInsertThread(100), "ConcurrentWriteTest" + i);
        }
        for (i = 10; i < 11; ++i) {
            threads[i] = new Thread((Runnable)new LuceneReadThread(100), "ConcurrentReadTest" + i);
        }
        for (i = 0; i < 11; ++i) {
            threads[i].start();
        }
        System.out.println("Started LuceneInsertReadMultithreadBaseTest test, waiting for " + threads.length + " threads to complete...");
        for (i = 0; i < 11; ++i) {
            threads[i].join();
        }
        System.out.println("LuceneInsertReadMultithreadBaseTest all threads completed");
        OIndex idx = schema.getClass("City").getClassIndex("City.name");
        Assert.assertEquals((long)idx.getSize(), (long)1001L);
    }

    public class LuceneReadThread
    implements Runnable {
        private final int cycle;
        private ODatabaseDocument databaseDocumentTx;

        public LuceneReadThread(int cycle) {
            this.cycle = cycle;
        }

        @Override
        public void run() {
            this.databaseDocumentTx = new ODatabaseDocumentTx(LuceneInsertReadMultithreadTest.this.url);
            this.databaseDocumentTx.open("admin", "admin");
            OSchema schema = this.databaseDocumentTx.getMetadata().getSchema();
            OIndex idx = schema.getClass("City").getClassIndex("City.name");
            for (int i = 0; i < this.cycle; ++i) {
                this.databaseDocumentTx.command((OCommandRequest)new OSQLSynchQuery("select from city where name LUCENE 'Rome'")).execute(new Object[0]);
            }
        }
    }

    public class LuceneInsertThread
    implements Runnable {
        private ODatabaseDocumentTx db;
        private int cycle = 0;
        private int commitBuf = 500;

        public LuceneInsertThread(int cycle) {
            this.cycle = cycle;
        }

        @Override
        public void run() {
            this.db = new ODatabaseDocumentTx(LuceneInsertReadMultithreadTest.this.url);
            this.db.open("admin", "admin");
            this.db.declareIntent((OIntent)new OIntentMassiveInsert());
            this.db.begin();
            for (int i = 0; i < this.cycle; ++i) {
                ODocument doc = new ODocument("City");
                doc.field("name", (Object)"Rome");
                this.db.save((ORecord)doc);
                if (i % this.commitBuf != 0) continue;
                this.db.commit();
                this.db.begin();
            }
            this.db.commit();
            this.db.close();
        }
    }
}

