/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.test;

import com.orientechnologies.orient.core.db.ODatabaseSession;
import com.orientechnologies.orient.core.db.ODatabaseType;
import com.orientechnologies.orient.core.db.OrientDB;
import com.orientechnologies.orient.core.db.OrientDBConfig;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.intent.OIntent;
import com.orientechnologies.orient.core.intent.OIntentMassiveInsert;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class LuceneInsertMultithreadTest {
    private static final int THREADS = 10;
    private static final int RTHREADS = 1;
    private static final int CYCLE = 100;
    private static String buildDirectory;
    private static final String dbName;
    private static final ODatabaseType databaseType;
    private static final OrientDB orientDB;

    @Test
    public void testConcurrentInsertWithIndex() throws Exception {
        int i;
        if (orientDB.exists(dbName)) {
            orientDB.drop(dbName);
        }
        orientDB.create(dbName, databaseType);
        ODatabaseSession databaseDocumentTx = orientDB.open(dbName, "admin", "admin");
        OSchema schema = databaseDocumentTx.getMetadata().getSchema();
        if (schema.getClass("City") == null) {
            OClass oClass = schema.createClass("City");
            oClass.createProperty("name", OType.STRING);
            oClass.createIndex("City.name", "FULLTEXT", null, null, "LUCENE", new String[]{"name"});
        }
        Thread[] threads = new Thread[11];
        for (i = 0; i < 10; ++i) {
            threads[i] = new Thread((Runnable)new LuceneInsertThread(100), "ConcurrentWriteTest" + i);
        }
        for (i = 10; i < 11; ++i) {
            threads[i] = new Thread((Runnable)new LuceneReadThread(100), "ConcurrentReadTest" + i);
        }
        for (i = 0; i < 11; ++i) {
            threads[i].start();
        }
        for (i = 0; i < 11; ++i) {
            threads[i].join();
        }
        OIndex idx = schema.getClass("City").getClassIndex("City.name");
        Assertions.assertThat((long)idx.getSize()).isEqualTo(1001L);
        orientDB.drop(dbName);
    }

    static {
        String storageType;
        String config;
        System.getProperty("buildDirectory", ".");
        if (buildDirectory == null) {
            buildDirectory = ".";
        }
        if ("ci".equals(config = System.getProperty("orientdb.test.env")) || "release".equals(config)) {
            storageType = "plocal";
            databaseType = ODatabaseType.PLOCAL;
        } else {
            storageType = "memory";
            databaseType = ODatabaseType.MEMORY;
        }
        dbName = "multiThread";
        orientDB = new OrientDB(storageType + ":" + buildDirectory, OrientDBConfig.defaultConfig());
    }

    public class LuceneReadThread
    implements Runnable {
        private final int cycle;
        private ODatabaseDocument databaseDocumentTx;

        LuceneReadThread(int cycle) {
            this.cycle = cycle;
        }

        @Override
        public void run() {
            this.databaseDocumentTx = orientDB.open(dbName, "admin", "admin");
            OSchema schema = this.databaseDocumentTx.getMetadata().getSchema();
            OIndex idx = schema.getClass("City").getClassIndex("City.name");
            for (int i = 0; i < this.cycle; ++i) {
                idx.get((Object)"Rome");
            }
        }
    }

    public static class LuceneInsertThread
    implements Runnable {
        private ODatabaseSession db;
        private final int cycle;
        private final int commitBuf = 500;

        LuceneInsertThread(int cycle) {
            this.cycle = cycle;
        }

        @Override
        public void run() {
            this.db = orientDB.open(dbName, "admin", "admin");
            this.db.declareIntent((OIntent)new OIntentMassiveInsert());
            this.db.begin();
            for (int i = 0; i < this.cycle; ++i) {
                ODocument doc = new ODocument("City");
                doc.field("name", (Object)"Rome");
                this.db.save((Object)doc);
                if (i % 500 != 0) continue;
                this.db.commit();
                this.db.begin();
            }
            this.db.commit();
            this.db.close();
        }
    }
}

