/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.test;

import com.orientechnologies.lucene.test.BaseLuceneTest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class LuceneInsertIntegrityRemoteTest
extends BaseLuceneTest {
    @Before
    public void init() {
        OSchema schema = this.db.getMetadata().getSchema();
        OClass oClass = schema.createClass("City");
        oClass.createProperty("name", OType.STRING);
        this.db.command((OCommandRequest)new OCommandSQL("create index City.name on City (name) FULLTEXT ENGINE LUCENE")).execute(new Object[0]);
    }

    @Test
    @Ignore
    public void testInsertUpdateWithIndex() throws Exception {
        this.db.getMetadata().reload();
        OSchema schema = this.db.getMetadata().getSchema();
        ODocument doc = new ODocument("City");
        doc.field("name", (Object)"Rome");
        this.db.begin();
        this.db.save((ORecord)doc);
        this.db.commit();
        OIndex idx = schema.getClass("City").getClassIndex("City.name");
        Collection coll = (Collection)idx.get((Object)"Rome");
        Assert.assertEquals((long)coll.size(), (long)1L);
        doc = (ODocument)this.db.load((ORID)coll.iterator().next());
        Assert.assertEquals((Object)doc.field("name"), (Object)"Rome");
        this.db.begin();
        doc.field("name", (Object)"London");
        this.db.save((ORecord)doc);
        this.db.commit();
        coll = (Collection)idx.get((Object)"Rome");
        Assert.assertEquals((long)coll.size(), (long)0L);
        coll = (Collection)idx.get((Object)"London");
        Assert.assertEquals((long)coll.size(), (long)1L);
        doc = (ODocument)this.db.load((ORID)coll.iterator().next());
        Assert.assertEquals((Object)doc.field("name"), (Object)"London");
        this.db.begin();
        doc.field("name", (Object)"Berlin");
        this.db.save((ORecord)doc);
        this.db.commit();
        doc = (ODocument)this.db.load(doc.getIdentity(), null, true);
        Assert.assertEquals((Object)doc.field("name"), (Object)"Berlin");
        coll = (Collection)idx.get((Object)"Rome");
        Assert.assertEquals((long)coll.size(), (long)0L);
        coll = (Collection)idx.get((Object)"London");
        Assert.assertEquals((long)coll.size(), (long)0L);
        coll = (Collection)idx.get((Object)"Berlin");
        Assert.assertEquals((long)idx.getSize(), (long)1L);
        Assert.assertEquals((long)coll.size(), (long)1L);
        Thread.sleep(1000L);
        doc = (ODocument)this.db.load(doc.getIdentity(), null, true);
        Assert.assertEquals((Object)doc.field("name"), (Object)"Berlin");
        schema = this.db.getMetadata().getSchema();
        idx = schema.getClass("City").getClassIndex("City.name");
        Assert.assertEquals((long)idx.getSize(), (long)1L);
        coll = (Collection)idx.get((Object)"Rome");
        Assert.assertEquals((long)coll.size(), (long)0L);
        coll = (Collection)idx.get((Object)"London");
        Assert.assertEquals((long)coll.size(), (long)0L);
        coll = (Collection)idx.get((Object)"Berlin");
        Assert.assertEquals((long)coll.size(), (long)1L);
    }
}

