/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.test;

import com.orientechnologies.lucene.test.BaseLuceneTest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.script.OCommandScript;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class LuceneInsertDeleteTest
extends BaseLuceneTest {
    @Before
    public void init() {
        OSchema schema = this.db.getMetadata().getSchema();
        OClass oClass = schema.createClass("City");
        oClass.createProperty("name", OType.STRING);
        this.db.command((OCommandRequest)new OCommandSQL("create index City.name on City (name) FULLTEXT ENGINE LUCENE")).execute(new Object[0]);
    }

    @Test
    public void testInsertUpdateWithIndex() throws Exception {
        this.db.getMetadata().reload();
        OSchema schema = this.db.getMetadata().getSchema();
        ODocument doc = new ODocument("City");
        doc.field("name", (Object)"Rome");
        this.db.save((ORecord)doc);
        OIndex idx = schema.getClass("City").getClassIndex("City.name");
        Collection coll = (Collection)idx.get((Object)"Rome");
        Assertions.assertThat((Iterable)coll).hasSize(1);
        Assertions.assertThat((long)idx.getSize()).isEqualTo(2L);
        OIdentifiable next = (OIdentifiable)coll.iterator().next();
        doc = (ODocument)this.db.load(next.getRecord());
        this.db.delete((ORecord)doc);
        coll = (Collection)idx.get((Object)"Rome");
        Assertions.assertThat((Iterable)coll).hasSize(0);
        Assertions.assertThat((long)idx.getSize()).isEqualTo(1L);
    }

    @Test
    public void testDeleteWithQueryOnClosedIndex() throws Exception {
        InputStream stream = ClassLoader.getSystemResourceAsStream("testLuceneIndex.sql");
        this.db.command((OCommandRequest)new OCommandScript("sql", this.getScriptFromStream(stream))).execute(new Object[0]);
        this.db.command((OCommandRequest)new OCommandSQL("create index Song.title on Song (title) FULLTEXT ENGINE LUCENE metadata {'closeAfterInterval':1000 , 'firstFlushAfter':1000 }")).execute(new Object[0]);
        List docs = this.db.query((OQuery)new OSQLSynchQuery("select from Song where title lucene 'mountain'"), new Object[0]);
        Assertions.assertThat((List)docs).hasSize(4);
        TimeUnit.SECONDS.sleep(5L);
        this.db.command((OCommandRequest)new OCommandSQL("delete vertex from Song where title lucene 'mountain'")).execute(new Object[0]);
        docs = this.db.query((OQuery)new OSQLSynchQuery("select from Song where  title lucene 'mountain'"), new Object[0]);
        Assertions.assertThat((List)docs).hasSize(0);
    }
}

