/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.test;

import com.orientechnologies.lucene.test.BaseLuceneTest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.OVertex;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LuceneGraphTXTest
extends BaseLuceneTest {
    @Before
    public void init() {
        OClass type = this.db.createVertexClass("City");
        type.createProperty("name", OType.STRING);
        this.db.command((OCommandRequest)new OCommandSQL("create index City.name on City (name) FULLTEXT ENGINE LUCENE")).execute(new Object[0]);
    }

    @Test
    public void graphTxTest() throws Exception {
        OVertex v = this.db.newVertex("City");
        v.setProperty("name", (Object)"London");
        this.db.save((ORecord)v);
        Collection results = (Collection)this.db.command((OCommandRequest)new OCommandSQL("select from City where name lucene 'London'")).execute(new Object[0]);
        Assert.assertEquals((long)results.size(), (long)1L);
        v.setProperty("name", (Object)"Berlin");
        v.save();
        results = (Collection)this.db.command((OCommandRequest)new OCommandSQL("select from City where name lucene 'Berlin'")).execute(new Object[0]);
        Assert.assertEquals((long)results.size(), (long)1L);
        results = (Collection)this.db.command((OCommandRequest)new OCommandSQL("select from City where name lucene 'London'")).execute(new Object[0]);
        Assert.assertEquals((long)results.size(), (long)0L);
        this.db.commit();
        results = (Collection)this.db.command((OCommandRequest)new OCommandSQL("select from City where name lucene 'Berlin'")).execute(new Object[0]);
        Assert.assertEquals((long)results.size(), (long)1L);
        results = (Collection)this.db.command((OCommandRequest)new OCommandSQL("select from City where name lucene 'London'")).execute(new Object[0]);
        Assert.assertEquals((long)results.size(), (long)0L);
    }
}

