/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.test;

import com.orientechnologies.lucene.index.OLuceneIndexNotUnique;
import com.orientechnologies.lucene.test.BaseLuceneTest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LuceneGetSearcherTest
extends BaseLuceneTest {
    @Before
    public void init() {
        OSchema schema = this.db.getMetadata().getSchema();
        OClass v = schema.getClass("V");
        OClass song = schema.createClass("Person");
        song.setSuperClass(v);
        song.createProperty("isDeleted", OType.BOOLEAN);
        this.db.command((OCommandRequest)new OCommandSQL("create index Person.isDeleted on Person (isDeleted) FULLTEXT ENGINE LUCENE")).execute(new Object[0]);
    }

    @Test
    public void testSearcherInstance() {
        OIndex index = this.db.getMetadata().getIndexManager().getIndex("Person.isDeleted");
        Assert.assertEquals((Object)true, (Object)(index.getInternal() instanceof OLuceneIndexNotUnique));
        OLuceneIndexNotUnique idx = (OLuceneIndexNotUnique)index.getInternal();
        Assert.assertNotNull((Object)idx.searcher());
    }
}

