/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.test;

import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import java.io.File;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LuceneFreezeReleaseTest {
    @Before
    public void setUp() throws Exception {
        OFileUtils.deleteRecursively((File)new File("./target/freezeRelease"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void freezeReleaseTest() {
        if (this.isWindows()) {
            return;
        }
        ODatabaseDocumentTx db = new ODatabaseDocumentTx("plocal:target/freezeRelease");
        db.create();
        OSchema schema = db.getMetadata().getSchema();
        OClass person = schema.createClass("Person");
        person.createProperty("name", OType.STRING);
        db.command((OCommandRequest)new OCommandSQL("create index Person.name on Person (name) FULLTEXT ENGINE LUCENE")).execute(new Object[0]);
        db.save((Object)new ODocument("Person").field("name", (Object)"John"));
        try {
            Collection results = (Collection)db.command((OCommandRequest)new OCommandSQL("select from Person where name lucene 'John'")).execute(new Object[0]);
            Assert.assertEquals((long)1L, (long)results.size());
            db.freeze();
            results = (Collection)db.command((OCommandRequest)new OCommandSQL("select from Person where name lucene 'John'")).execute(new Object[0]);
            Assert.assertEquals((long)1L, (long)results.size());
            db.release();
            db.save((Object)new ODocument("Person").field("name", (Object)"John"));
            results = (Collection)db.command((OCommandRequest)new OCommandSQL("select from Person where name lucene 'John'")).execute(new Object[0]);
            Assert.assertEquals((long)2L, (long)results.size());
        }
        finally {
            db.drop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void freezeReleaseMisUsageTest() {
        if (this.isWindows()) {
            return;
        }
        ODatabaseDocumentTx db = new ODatabaseDocumentTx("plocal:target/freezeRelease");
        db.create();
        OSchema schema = db.getMetadata().getSchema();
        OClass person = schema.createClass("Person");
        person.createProperty("name", OType.STRING);
        db.command((OCommandRequest)new OCommandSQL("create index Person.name on Person (name) FULLTEXT ENGINE LUCENE")).execute(new Object[0]);
        db.save((Object)new ODocument("Person").field("name", (Object)"John"));
        try {
            Collection results = (Collection)db.command((OCommandRequest)new OCommandSQL("select from Person where name lucene 'John'")).execute(new Object[0]);
            Assert.assertEquals((long)1L, (long)results.size());
            db.freeze();
            db.freeze();
            results = (Collection)db.command((OCommandRequest)new OCommandSQL("select from Person where name lucene 'John'")).execute(new Object[0]);
            Assert.assertEquals((long)1L, (long)results.size());
            db.release();
            db.release();
            db.save((Object)new ODocument("Person").field("name", (Object)"John"));
            results = (Collection)db.command((OCommandRequest)new OCommandSQL("select from Person where name lucene 'John'")).execute(new Object[0]);
            Assert.assertEquals((long)2L, (long)results.size());
        }
        finally {
            db.drop();
        }
    }

    private boolean isWindows() {
        String osName = System.getProperty("os.name").toLowerCase();
        return osName.contains("win");
    }
}

