/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.test;

import com.orientechnologies.lucene.test.BaseLuceneTest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class LuceneFacetTest
extends BaseLuceneTest {
    @Before
    public void init() {
        OSchema schema = this.db.getMetadata().getSchema();
        OClass oClass = schema.createClass("Item");
        oClass.createProperty("name", OType.STRING);
        oClass.createProperty("category", OType.STRING);
        this.db.command((OCommandRequest)new OCommandSQL("create index Item.name_category on Item (name,category) FULLTEXT ENGINE LUCENE METADATA { 'facetFields' : ['category']}")).execute(new Object[0]);
        ODocument doc = new ODocument("Item");
        doc.field("name", (Object)"Pioneer");
        doc.field("category", (Object)"Electronic/HiFi");
        this.db.save((ORecord)doc);
        doc = new ODocument("Item");
        doc.field("name", (Object)"Hitachi");
        doc.field("category", (Object)"Electronic/HiFi");
        this.db.save((ORecord)doc);
        doc = new ODocument("Item");
        doc.field("name", (Object)"Philips");
        doc.field("category", (Object)"Electronic/HiFi");
        this.db.save((ORecord)doc);
        doc = new ODocument("Item");
        doc.field("name", (Object)"HP");
        doc.field("category", (Object)"Electronic/Computer");
        this.db.save((ORecord)doc);
        this.db.commit();
    }

    @Test
    @Ignore
    public void baseFacetTest() {
        List result = (List)this.db.command((OCommandRequest)new OSQLSynchQuery("select *,$facet from Item where name lucene '(name:P*)' limit 1 ")).execute(new Object[0]);
        Assert.assertEquals((long)result.size(), (long)1L);
        List facets = (List)((ODocument)result.get(0)).field("$facet");
        Assert.assertEquals((long)facets.size(), (long)1L);
        ODocument facet = (ODocument)facets.get(0);
        Assert.assertEquals((Object)facet.field("childCount"), (Object)1);
        Assert.assertEquals((Object)facet.field("value"), (Object)2);
        Assert.assertEquals((Object)facet.field("dim"), (Object)"category");
        List labelsValues = (List)facet.field("labelsValue");
        Assert.assertEquals((long)labelsValues.size(), (long)1L);
        ODocument labelValues = (ODocument)labelsValues.get(0);
        Assert.assertEquals((Object)labelValues.field("value"), (Object)2);
        Assert.assertEquals((Object)labelValues.field("label"), (Object)"Electronic");
        result = (List)this.db.command((OCommandRequest)new OSQLSynchQuery("select *,$facet from Item where name lucene { 'q' : 'H*', 'drillDown' : 'category:Electronic' }  limit 1 ")).execute(new Object[0]);
        Assert.assertEquals((long)result.size(), (long)1L);
        facets = (List)((ODocument)result.get(0)).field("$facet");
        Assert.assertEquals((long)facets.size(), (long)1L);
        facet = (ODocument)facets.get(0);
        Assert.assertEquals((Object)facet.field("childCount"), (Object)2);
        Assert.assertEquals((Object)facet.field("value"), (Object)2);
        Assert.assertEquals((Object)facet.field("dim"), (Object)"category");
        labelsValues = (List)facet.field("labelsValue");
        Assert.assertEquals((long)labelsValues.size(), (long)2L);
        labelValues = (ODocument)labelsValues.get(0);
        Assert.assertEquals((Object)labelValues.field("value"), (Object)1);
        Assert.assertEquals((Object)labelValues.field("label"), (Object)"HiFi");
        labelValues = (ODocument)labelsValues.get(1);
        Assert.assertEquals((Object)labelValues.field("value"), (Object)1);
        Assert.assertEquals((Object)labelValues.field("label"), (Object)"Computer");
    }
}

