/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.test;

import com.orientechnologies.lucene.test.BaseLuceneTest;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.tool.ODatabaseExport;
import com.orientechnologies.orient.core.db.tool.ODatabaseImport;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LuceneExportImportTest
extends BaseLuceneTest {
    @Before
    public void init() {
        OSchema schema = this.db.getMetadata().getSchema();
        OClass oClass = schema.createClass("City");
        oClass.createProperty("name", OType.STRING);
        this.db.command((OCommandRequest)new OCommandSQL("create index City.name on City (name) FULLTEXT ENGINE LUCENE")).execute(new Object[0]);
        ODocument doc = new ODocument("City");
        doc.field("name", (Object)"Rome");
        this.db.save((ORecord)doc);
    }

    @Test
    public void testExportImport() {
        String file = "./target/exportTest.json";
        List query = this.db.query((OQuery)new OSQLSynchQuery("select from City where name lucene 'Rome'"), new Object[0]);
        Assert.assertEquals((long)query.size(), (long)1L);
        try {
            new ODatabaseExport((ODatabaseDocumentInternal)this.db, file, new OCommandOutputListener(){

                public void onMessage(String s) {
                }
            }).exportDatabase();
            this.db.drop();
            this.db.create();
            GZIPInputStream stream = new GZIPInputStream(new FileInputStream(file + ".gz"));
            new ODatabaseImport((ODatabaseDocumentInternal)this.db, (InputStream)stream, new OCommandOutputListener(){

                public void onMessage(String s) {
                }
            }).importDatabase();
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        Assertions.assertThat((long)this.db.countClass("City")).isEqualTo(1L);
        OIndex index = this.db.getMetadata().getIndexManager().getIndex("City.name");
        Assertions.assertThat((String)index.getType()).isEqualTo((Object)OClass.INDEX_TYPE.FULLTEXT.toString());
        Assertions.assertThat((String)index.getAlgorithm()).isEqualTo((Object)"LUCENE");
        query = this.db.query((OQuery)new OSQLSynchQuery("select from City where name lucene 'Rome'"), new Object[0]);
        Assertions.assertThat((List)query).hasSize(1);
    }
}

