/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.test;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.lucene.test.BaseLuceneTest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.script.OCommandScript;
import com.orientechnologies.orient.core.metadata.OMetadataInternal;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import java.io.InputStream;
import java.util.logging.Level;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class LuceneDropClusterTest
extends BaseLuceneTest {
    @Test
    public void shouldRemoveCluster() throws Exception {
        OLogManager.instance().setConsoleLevel(Level.FINE.getName());
        InputStream stream = ClassLoader.getSystemResourceAsStream("testLuceneIndex.sql");
        this.db.command((OCommandRequest)new OCommandScript("sql", this.getScriptFromStream(stream))).execute(new Object[0]);
        this.db.command((OCommandRequest)new OCommandSQL("create index Song.title on Song (title) FULLTEXT ENGINE LUCENE METADATA {\"default\":\"" + StandardAnalyzer.class.getName() + "\"}")).execute(new Object[0]);
        this.db.command((OCommandRequest)new OCommandSQL("create index Song.author on Song (author) FULLTEXT ENGINE LUCENE METADATA {\"default\":\"" + StandardAnalyzer.class.getName() + "\"}")).execute(new Object[0]);
        OMetadataInternal metadata = this.db.getMetadata();
        long initialIndexSize = metadata.getIndexManager().getIndex("Song.title").getSize();
        int[] clusterIds = metadata.getSchema().getClass("Song").getClusterIds();
        this.db.dropCluster(clusterIds[1], true);
        long afterDropIndexSize = metadata.getIndexManager().getIndex("Song.title").getSize();
        Assertions.assertThat((long)afterDropIndexSize).isLessThan(initialIndexSize);
    }
}

