/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.test;

import com.orientechnologies.lucene.test.BaseLuceneTest;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class LuceneCreateJavaApiTest
extends BaseLuceneTest {
    @Before
    public void init() {
        OSchema schema = this.db.getMetadata().getSchema();
        OClass v = schema.getClass("V");
        OClass song = schema.createClass("Song");
        song.setSuperClass(v);
        song.createProperty("title", OType.STRING);
        song.createProperty("author", OType.STRING);
        song.createProperty("description", OType.STRING);
    }

    @Test
    public void testCreateIndex() {
        OSchema schema = this.db.getMetadata().getSchema();
        OClass song = schema.getClass("Song");
        ODocument meta = new ODocument().field("analyzer", (Object)StandardAnalyzer.class.getName());
        OIndex lucene = song.createIndex("Song.title", OClass.INDEX_TYPE.FULLTEXT.toString(), null, meta, "LUCENE", new String[]{"title"});
        Assertions.assertThat((Comparable)lucene).isNotNull();
        Assertions.assertThat((boolean)lucene.getMetadata().containsField("analyzer")).isTrue();
        Assertions.assertThat((Object)lucene.getMetadata().field("analyzer")).isEqualTo((Object)StandardAnalyzer.class.getName());
    }

    @Test
    public void testCreateIndexCompositeWithDefaultAnalyzer() {
        OSchema schema = this.db.getMetadata().getSchema();
        OClass song = schema.getClass("Song");
        OIndex lucene = song.createIndex("Song.author_description", OClass.INDEX_TYPE.FULLTEXT.toString(), null, null, "LUCENE", new String[]{"author", "description"});
        Assertions.assertThat((Comparable)lucene).isNotNull();
        Assertions.assertThat((boolean)lucene.getMetadata().containsField("analyzer")).isTrue();
        Assertions.assertThat((Object)lucene.getMetadata().field("analyzer")).isEqualTo((Object)StandardAnalyzer.class.getName());
    }
}

