/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.test;

import com.orientechnologies.lucene.test.BaseLuceneTest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.script.OCommandScript;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.io.InputStream;
import java.util.List;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.junit.Assert;
import org.junit.Test;

public class LuceneCreateIndexTest
extends BaseLuceneTest {
    @Test
    public void loadAndTest() {
        InputStream stream = ClassLoader.getSystemResourceAsStream("testLuceneIndex.sql");
        this.db.command((OCommandRequest)new OCommandScript("sql", this.getScriptFromStream(stream))).execute(new Object[0]);
        this.db.command((OCommandRequest)new OCommandSQL("create index Song.title on Song (title) FULLTEXT ENGINE LUCENE METADATA {\"analyzer\":\"" + StandardAnalyzer.class.getName() + "\"}")).execute(new Object[0]);
        this.db.command((OCommandRequest)new OCommandSQL("create index Song.author on Song (author) FULLTEXT ENGINE LUCENE METADATA {\"analyzer\":\"" + StandardAnalyzer.class.getName() + "\"}")).execute(new Object[0]);
        ODocument doc = new ODocument("Song");
        doc.field("title", (Object)"Local");
        doc.field("author", (Object)"Local");
        this.db.save((ORecord)doc);
        this.testMetadata();
        this.assertQuery();
        this.assertNewQuery();
        this.db.close();
        this.db.open("admin", "admin");
        this.assertQuery();
        this.assertNewQuery();
    }

    protected void testMetadata() {
        ODocument index = this.db.getMetadata().getIndexManager().getIndex("Song.title").getMetadata();
        Assert.assertEquals((Object)index.field("analyzer"), (Object)StandardAnalyzer.class.getName());
    }

    protected void assertQuery() {
        List docs = this.db.query((OQuery)new OSQLSynchQuery("select * from Song where title LUCENE \"mountain\""), new Object[0]);
        Assert.assertEquals((long)4L, (long)docs.size());
        docs = this.db.query((OQuery)new OSQLSynchQuery("select * from Song where author LUCENE \"Fabbio\""), new Object[0]);
        Assert.assertEquals((long)87L, (long)docs.size());
        System.out.println("-------------");
        String query = "select * from Song where title LUCENE \"mountain\" and author LUCENE \"Fabbio\"  ";
        docs = this.db.query((OQuery)new OSQLSynchQuery(query), new Object[0]);
        Assert.assertEquals((long)1L, (long)docs.size());
        query = "select * from Song where title LUCENE \"mountain\"  and author = 'Fabbio'";
        docs = this.db.query((OQuery)new OSQLSynchQuery(query), new Object[0]);
        Assert.assertEquals((long)1L, (long)docs.size());
    }

    protected void assertNewQuery() {
        List docs = this.db.query((OQuery)new OSQLSynchQuery("select * from Song where [title] LUCENE \"(title:Local)\""), new Object[0]);
        Assert.assertEquals((long)1L, (long)docs.size());
    }
}

