/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.test;

import com.orientechnologies.lucene.test.BaseLuceneTest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.script.OCommandScript;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.io.InputStream;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LuceneContextTest
extends BaseLuceneTest {
    @Before
    public void init() {
        InputStream stream = ClassLoader.getSystemResourceAsStream("testLuceneIndex.sql");
        this.db.command((OCommandRequest)new OCommandScript("sql", this.getScriptFromStream(stream))).execute(new Object[0]);
        this.db.command((OCommandRequest)new OCommandSQL("create index Song.title on Song (title) FULLTEXT ENGINE LUCENE")).execute(new Object[0]);
        this.db.command((OCommandRequest)new OCommandSQL("create index Song.author on Song (author) FULLTEXT ENGINE LUCENE")).execute(new Object[0]);
    }

    @Test
    public void testContext() {
        List docs = this.db.query((OQuery)new OSQLSynchQuery("select *,$score from Song where [title] LUCENE \"(title:man)\""), new Object[0]);
        Assert.assertEquals((long)docs.size(), (long)14L);
        Float latestScore = Float.valueOf(100.0f);
        for (ODocument doc : docs) {
            Float score = (Float)doc.field("$score");
            Assert.assertNotNull((Object)score);
            Assert.assertTrue((score.floatValue() <= latestScore.floatValue() ? 1 : 0) != 0);
            latestScore = score;
        }
        docs = this.db.query((OQuery)new OSQLSynchQuery("select *,$totalHits,$Song_title_totalHits from Song where [title] LUCENE \"(title:man)\" limit 1"), new Object[0]);
        Assert.assertEquals((long)docs.size(), (long)1L);
        ODocument doc = (ODocument)docs.iterator().next();
        Assert.assertEquals((Object)new Long(14L), (Object)doc.field("$totalHits"));
        Assert.assertEquals((Object)new Long(14L), (Object)doc.field("$Song_title_totalHits"));
    }
}

