/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.test;

import com.orientechnologies.lucene.test.BaseLuceneTest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.memory.MemoryIndex;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LuceneBooleanIndexTest
extends BaseLuceneTest {
    @Before
    public void init() {
        OSchema schema = this.db.getMetadata().getSchema();
        OClass v = schema.getClass("V");
        OClass song = schema.createClass("Person");
        song.setSuperClass(v);
        song.createProperty("isDeleted", OType.BOOLEAN);
        this.db.command((OCommandRequest)new OCommandSQL("create index Person.isDeleted on Person (isDeleted) FULLTEXT ENGINE LUCENE")).execute(new Object[0]);
    }

    @Test
    public void insertPerson() {
        for (int i = 0; i < 1000; ++i) {
            ODocument doc = new ODocument("Person");
            doc.field("isDeleted", (Object)(i % 2 == 0 ? 1 : 0));
            this.db.save((ORecord)doc);
        }
        List docs = this.db.query((OQuery)new OSQLSynchQuery("select from Person where isDeleted lucene false"), new Object[0]);
        Assert.assertEquals((long)500L, (long)docs.size());
        Assert.assertEquals((Object)false, (Object)((ODocument)docs.get(0)).field("isDeleted"));
        docs = this.db.query((OQuery)new OSQLSynchQuery("select from Person where isDeleted lucene true"), new Object[0]);
        Assert.assertEquals((long)500L, (long)docs.size());
        Assert.assertEquals((Object)true, (Object)((ODocument)docs.get(0)).field("isDeleted"));
    }

    @Test
    public void testMemoryIndex() throws ParseException {
        MemoryIndex index = new MemoryIndex();
        Document doc = new Document();
        doc.add((IndexableField)new StringField("text", "my text", Field.Store.YES));
        StandardAnalyzer analyzer = new StandardAnalyzer();
        for (IndexableField field : doc.getFields()) {
            index.addField(field.name(), field.stringValue(), (Analyzer)analyzer);
        }
        QueryParser parser = new QueryParser("text", (Analyzer)analyzer);
        float score = index.search(parser.parse("+text:my"));
    }
}

