/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.test;

import com.orientechnologies.orient.core.db.ODatabaseSession;
import com.orientechnologies.orient.core.db.ODatabaseType;
import com.orientechnologies.orient.core.db.OrientDB;
import com.orientechnologies.orient.core.db.OrientDBConfig;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Locale;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class LuceneBackupRestoreTest {
    @Rule
    public TestName name = new TestName();
    private File tempFolder;
    private OrientDB orientDB;
    private ODatabaseSession databaseDocumentTx;

    @Before
    public void setUp() throws Exception {
        String os = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
        Assume.assumeFalse((boolean)os.contains("win"));
        String buildDirectory = System.getProperty("buildDirectory", "target");
        File buildDirectoryFile = new File(buildDirectory);
        this.tempFolder = new File(buildDirectoryFile, this.name.getMethodName());
        this.orientDB = new OrientDB("plocal:" + this.tempFolder.getCanonicalPath(), OrientDBConfig.defaultConfig());
        this.dropIfExists();
        String dbName = this.getClass().getSimpleName();
        this.orientDB.create(dbName, ODatabaseType.PLOCAL);
        this.databaseDocumentTx = this.orientDB.open(dbName, "admin", "admin");
        this.databaseDocumentTx.command("create class City ", new Object[0]);
        this.databaseDocumentTx.command("create property City.name string", new Object[0]);
        this.databaseDocumentTx.command("create index City.name on City (name) FULLTEXT ENGINE LUCENE", new Object[0]);
        ODocument doc = new ODocument("City");
        doc.field("name", (Object)"Rome");
        this.databaseDocumentTx.save((Object)doc);
    }

    private void dropIfExists() {
        String dbName = this.getClass().getSimpleName();
        if (this.orientDB.exists(dbName)) {
            this.orientDB.drop(dbName);
        }
    }

    @After
    public void tearDown() throws Exception {
        String os = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
        if (!os.contains("win")) {
            this.dropIfExists();
        }
    }

    @Test
    public void shouldBackupAndRestore() throws IOException {
        File backupFile = new File(this.tempFolder, "backupRestore.gz");
        try (OResultSet query = this.databaseDocumentTx.query("select from City where name lucene 'Rome'", new Object[0]);){
            Assertions.assertThat((Iterator)query).hasSize(1);
        }
        this.databaseDocumentTx.backup((OutputStream)new FileOutputStream(backupFile), null, null, null, 9, 0x100000);
        this.orientDB.drop(this.getClass().getSimpleName());
        this.orientDB.create(this.getClass().getSimpleName(), ODatabaseType.PLOCAL);
        this.databaseDocumentTx = this.orientDB.open(this.getClass().getSimpleName(), "admin", "admin");
        FileInputStream stream = new FileInputStream(backupFile);
        this.databaseDocumentTx.restore((InputStream)stream, null, null, null);
        Assertions.assertThat((long)this.databaseDocumentTx.countClass("City")).isEqualTo(1L);
        OIndex index = this.databaseDocumentTx.getMetadata().getIndexManager().getIndex("City.name");
        Assertions.assertThat((Comparable)index).isNotNull();
        Assertions.assertThat((String)index.getType()).isEqualTo((Object)OClass.INDEX_TYPE.FULLTEXT.name());
        try (OResultSet query = this.databaseDocumentTx.query("select from City where name lucene 'Rome'", new Object[0]);){
            Assertions.assertThat((Iterator)query).hasSize(1);
        }
    }
}

