/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.test;

import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseType;
import com.orientechnologies.orient.core.db.OrientDB;
import com.orientechnologies.orient.core.db.tool.ODatabaseImport;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.config.OServerParameterConfiguration;
import com.orientechnologies.orient.server.handler.OAutomaticBackup;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.zip.GZIPInputStream;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class LuceneAutomaticBackupRestoreTest {
    private static final String DBNAME = "OLuceneAutomaticBackupRestoreTest";
    private File tempFolder;
    @Rule
    public TestName name = new TestName();
    private OrientDB orientDB;
    private String URL = null;
    private String BACKUPDIR = null;
    private String BACKUFILE = null;
    private OServer server;
    private ODatabaseDocumentInternal db;

    @Before
    public void setUp() throws Exception {
        String os = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
        Assume.assumeFalse((boolean)os.contains("win"));
        String buildDirectory = System.getProperty("buildDirectory", "target");
        File buildDirectoryFile = new File(buildDirectory);
        this.tempFolder = new File(buildDirectoryFile, this.name.getMethodName());
        OFileUtils.deleteRecursively((File)this.tempFolder);
        Assert.assertTrue((boolean)this.tempFolder.mkdirs());
        System.setProperty("ORIENTDB_HOME", this.tempFolder.getCanonicalPath());
        String path = this.tempFolder.getCanonicalPath() + File.separator + "databases";
        this.server = new OServer(false){

            public Map<String, String> getAvailableStorageNames() {
                HashMap<String, String> result = new HashMap<String, String>();
                result.put(LuceneAutomaticBackupRestoreTest.DBNAME, LuceneAutomaticBackupRestoreTest.this.URL);
                return result;
            }
        };
        this.server.startup();
        this.orientDB = this.server.getContext();
        this.URL = "plocal:" + path + File.separator + DBNAME;
        this.BACKUPDIR = this.tempFolder.getCanonicalPath() + File.separator + "backups";
        this.BACKUFILE = this.BACKUPDIR + File.separator + DBNAME;
        File config = new File(this.tempFolder, "config");
        Assert.assertTrue((boolean)config.mkdirs());
        this.dropIfExists();
        this.orientDB.create(DBNAME, ODatabaseType.PLOCAL);
        this.db = (ODatabaseDocumentInternal)this.orientDB.open(DBNAME, "admin", "admin");
        this.db.command("create class City ", new Object[0]);
        this.db.command("create property City.name string", new Object[0]);
        this.db.command("create index City.name on City (name) FULLTEXT ENGINE LUCENE", new Object[0]);
        ODocument doc = new ODocument("City");
        doc.field("name", (Object)"Rome");
        this.db.save((Object)doc);
    }

    private void dropIfExists() {
        if (this.orientDB.exists(DBNAME)) {
            this.orientDB.drop(DBNAME);
        }
    }

    @After
    public void tearDown() throws Exception {
        String os = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
        if (!os.contains("win")) {
            this.dropIfExists();
            OFileUtils.deleteRecursively((File)this.tempFolder);
        }
    }

    @AfterClass
    public static void afterClass() {
        Orient orient = Orient.instance();
        if (orient != null) {
            orient.shutdown();
            orient.startup();
        }
    }

    @Test
    public void shouldBackupAndRestore() throws IOException, InterruptedException {
        try (OResultSet query = this.db.query("select from City where name lucene 'Rome'", new Object[0]);){
            Assertions.assertThat((Iterator)query).hasSize(1);
        }
        String jsonConfig = OIOUtils.readStreamAsString((InputStream)this.getClass().getClassLoader().getResourceAsStream("automatic-backup.json"));
        ODocument doc = new ODocument().fromJSON(jsonConfig);
        doc.field("enabled", (Object)true);
        doc.field("targetFileName", (Object)"${DBNAME}.zip");
        doc.field("targetDirectory", (Object)this.BACKUPDIR);
        doc.field("dbInclude", (Object)new String[]{DBNAME});
        doc.field("firstTime", (Object)new SimpleDateFormat("HH:mm:ss").format(new Date(System.currentTimeMillis() + 2000L)));
        OIOUtils.writeFile((File)new File(this.tempFolder.getCanonicalPath(), "config/automatic-backup.json"), (String)doc.toJSON());
        OAutomaticBackup aBackup = new OAutomaticBackup();
        OServerParameterConfiguration[] config = new OServerParameterConfiguration[]{};
        aBackup.config(this.server, config);
        final CountDownLatch latch = new CountDownLatch(1);
        aBackup.registerListener(new OAutomaticBackup.OAutomaticBackupListener(){

            public void onBackupCompleted(String database) {
                latch.countDown();
            }

            public void onBackupError(String database, Exception e) {
                latch.countDown();
            }
        });
        latch.await();
        aBackup.sendShutdown();
        this.dropIfExists();
        this.db = this.createAndOpen();
        FileInputStream stream = new FileInputStream(new File(this.BACKUFILE + ".zip"));
        this.db.restore((InputStream)stream, null, null, null);
        this.db.close();
        this.db = this.open();
        Assertions.assertThat((long)this.db.countClass("City")).isEqualTo(1L);
        OIndex index = this.db.getMetadata().getIndexManager().getIndex("City.name");
        Assertions.assertThat((Comparable)index).isNotNull();
        Assertions.assertThat((String)index.getType()).isEqualTo((Object)OClass.INDEX_TYPE.FULLTEXT.name());
        Assertions.assertThat((Iterator)this.db.query("select from City where name lucene 'Rome'", new Object[0])).hasSize(1);
    }

    @Test
    public void shouldExportImport() throws IOException, InterruptedException {
        try (OResultSet query = this.db.query("select from City where name lucene 'Rome'", new Object[0]);){
            Assertions.assertThat((Iterator)query).hasSize(1);
        }
        String jsonConfig = OIOUtils.readStreamAsString((InputStream)this.getClass().getClassLoader().getResourceAsStream("automatic-backup.json"));
        ODocument doc = new ODocument().fromJSON(jsonConfig);
        doc.field("enabled", (Object)true);
        doc.field("targetFileName", (Object)"${DBNAME}.json");
        doc.field("targetDirectory", (Object)this.BACKUPDIR);
        doc.field("mode", (Object)"EXPORT");
        doc.field("dbInclude", (Object)new String[]{DBNAME});
        doc.field("firstTime", (Object)new SimpleDateFormat("HH:mm:ss").format(new Date(System.currentTimeMillis() + 2000L)));
        OIOUtils.writeFile((File)new File(this.tempFolder, "config/automatic-backup.json"), (String)doc.toJSON());
        OAutomaticBackup aBackup = new OAutomaticBackup();
        OServerParameterConfiguration[] config = new OServerParameterConfiguration[]{};
        aBackup.config(this.server, config);
        final CountDownLatch latch = new CountDownLatch(1);
        aBackup.registerListener(new OAutomaticBackup.OAutomaticBackupListener(){

            public void onBackupCompleted(String database) {
                latch.countDown();
            }

            public void onBackupError(String database, Exception e) {
                latch.countDown();
            }
        });
        latch.await();
        aBackup.sendShutdown();
        this.db.close();
        this.dropIfExists();
        this.db = this.createAndOpen();
        try (GZIPInputStream stream = new GZIPInputStream(new FileInputStream(this.BACKUFILE + ".json.gz"));){
            new ODatabaseImport(this.db, (InputStream)stream, s -> {}).importDatabase();
        }
        this.db.close();
        this.db = this.open();
        Assertions.assertThat((long)this.db.countClass("City")).isEqualTo(1L);
        OIndex index = this.db.getMetadata().getIndexManager().getIndex("City.name");
        Assertions.assertThat((Comparable)index).isNotNull();
        Assertions.assertThat((String)index.getType()).isEqualTo((Object)OClass.INDEX_TYPE.FULLTEXT.name());
        Assertions.assertThat((Iterator)this.db.query("select from City where name lucene 'Rome'", new Object[0])).hasSize(1);
    }

    private ODatabaseDocumentInternal createAndOpen() {
        this.orientDB.create(DBNAME, ODatabaseType.PLOCAL);
        return this.open();
    }

    private ODatabaseDocumentInternal open() {
        return (ODatabaseDocumentInternal)this.orientDB.open(DBNAME, "admin", "admin");
    }
}

