/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.test;

import com.orientechnologies.lucene.test.BaseLuceneTest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DocumentEmbeddedTest
extends BaseLuceneTest {
    @Before
    public void init() {
        OClass type = this.db.getMetadata().getSchema().createClass("City");
        type.createProperty("name", OType.STRING);
        this.db.command((OCommandRequest)new OCommandSQL("create index City.name on City (name) FULLTEXT ENGINE LUCENE")).execute(new Object[0]);
    }

    @Test
    public void embeddedNoTx() {
        ODocument doc = new ODocument("City");
        doc.field("name", (Object)"London");
        this.db.save((ORecord)doc);
        doc = new ODocument("City");
        doc.field("name", (Object)"Rome");
        this.db.save((ORecord)doc);
        List results = (List)this.db.command((OCommandRequest)new OCommandSQL("select from City where name lucene 'London'")).execute(new Object[0]);
        Assert.assertEquals((long)results.size(), (long)1L);
    }

    @Test
    public void embeddedTx() {
        ODocument doc = new ODocument("City");
        this.db.begin();
        doc.field("name", (Object)"Berlin");
        this.db.save((ORecord)doc);
        this.db.commit();
        List results = (List)this.db.command((OCommandRequest)new OCommandSQL("select from City where name lucene 'Berlin'")).execute(new Object[0]);
        Assert.assertEquals((long)results.size(), (long)1L);
    }
}

