/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.test;

import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import java.io.IOException;
import java.io.InputStream;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TestName;

public abstract class BaseLuceneTest {
    @Rule
    public TestName name = new TestName();
    protected ODatabaseDocumentTx db;

    @Before
    public void setupDatabase() throws Throwable {
        String config = System.getProperty("orientdb.test.env", "memory");
        this.db = "ci".equals(config) || "release".equals(config) ? new ODatabaseDocumentTx("plocal:./target/databases/" + this.name.getMethodName()) : new ODatabaseDocumentTx("memory:" + this.name.getMethodName());
        if (this.db.exists()) {
            this.db.drop();
        }
        this.db.set(ODatabase.ATTRIBUTES.MINIMUMCLUSTERS, (Object)8);
        this.db.create();
    }

    @After
    public void dropDatabase() {
        this.db.activateOnCurrentThread();
        this.db.drop();
    }

    protected ODatabaseDocumentTx dropOrCreate(String url, boolean drop) {
        ODatabaseDocumentTx db = new ODatabaseDocumentTx(url);
        if (db.exists()) {
            db.open("admin", "admin");
            if (drop) {
                db.drop();
                db = new ODatabaseDocumentTx(url);
                db.create();
            }
        } else {
            db = new ODatabaseDocumentTx(url);
            db.create();
        }
        db.activateOnCurrentThread();
        return db;
    }

    protected String getScriptFromStream(InputStream in) {
        try {
            return OIOUtils.readStreamAsString((InputStream)in);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

