/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.sandbox;

import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Test;

public class VertexIndexTest {
    @Test
    public void testSpacesInQuery() throws IOException, ParseException {
        IndexWriterConfig conf = new IndexWriterConfig((Analyzer)new StandardAnalyzer());
        RAMDirectory directory = new RAMDirectory();
        IndexWriter writer = new IndexWriter((Directory)directory, conf);
        Document doc = new Document();
        doc.add((IndexableField)new TextField("name", "Max Water", Field.Store.YES));
        writer.addDocument((Iterable)doc);
        doc = new Document();
        doc.add((IndexableField)new TextField("name", "Max Waterson", Field.Store.YES));
        writer.addDocument((Iterable)doc);
        doc = new Document();
        doc.add((IndexableField)new TextField("name", "Cory Watney", Field.Store.YES));
        writer.addDocument((Iterable)doc);
        writer.commit();
        DirectoryReader reader = DirectoryReader.open((Directory)directory);
        IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
        StandardAnalyzer analyzer = new StandardAnalyzer();
        QueryParser queryParser = new QueryParser("name", (Analyzer)analyzer);
        Query query = queryParser.parse("name:Max AND name:Wat*");
        TopDocs topDocs = searcher.search(query, 10);
        Assertions.assertThat((long)topDocs.totalHits).isEqualTo(2L);
        int i = 0;
        while ((long)i < topDocs.totalHits) {
            Document found = searcher.doc(topDocs.scoreDocs[i].doc);
            Assertions.assertThat((String)found.get("name")).startsWith((CharSequence)"Max");
            ++i;
        }
        reader.close();
        writer.close();
    }

    @Test
    public void name() throws Exception {
    }

    @After
    public void deInit() {
        ODatabaseDocumentTx.closeAll();
    }
}

