/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.sandbox;

import com.orientechnologies.lucene.tests.OLuceneBaseTest;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.util.Iterator;
import org.apache.lucene.codecs.simpletext.SimpleTextCodec;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class LuceneSandboxTest
extends OLuceneBaseTest {
    @Before
    public void setUp() throws Exception {
        this.db.command("CREATE CLASS CDR", new Object[0]);
        this.db.command("CREATE PROPERTY  CDR.filename STRING", new Object[0]);
        this.db.command("INSERT into cdr(filename) values('MDCA10MCR201612291808.276388.eno.RRC.20161229183002.PROD_R4.eno.data') ", new Object[0]);
        this.db.command("INSERT into cdr(filename) values('MDCA20MCR201612291911.277904.eno.RRC.20161229193002.PROD_R4.eno.data') ", new Object[0]);
    }

    @Test
    public void shouldFetchOneDocumentWithExactMatchOnLuceneIndexStandardAnalyzer() throws Exception {
        this.db.command("CREATE INDEX cdr.filename ON cdr(filename) FULLTEXT ENGINE LUCENE ", new Object[0]);
        OResultSet res = this.db.query("select from cdr WHERE filename LUCENE ' RRC.20161229193002.PROD_R4.eno.data '", new Object[0]);
        Assertions.assertThat((Iterator)res).hasSize(2);
        res.close();
        res = this.db.query("select from cdr WHERE filename LUCENE ' \"MDCA20MCR201612291911.277904.eno.RRC.20161229193002.PROD_R4.eno.data\" '", new Object[0]);
        Assertions.assertThat((Iterator)res).hasSize(1);
        res.close();
        res = this.db.query("select from cdr WHERE filename LUCENE ' MDCA* '", new Object[0]);
        Assertions.assertThat((Iterator)res).hasSize(2);
        res.close();
    }

    @Test
    public void shouldFetchOneDocumentWithExactMatchOnLuceneIndexKeyWordAnalyzer() throws Exception {
        this.db.command("CREATE INDEX cdr.filename ON cdr(filename) FULLTEXT ENGINE LUCENE metadata { 'allowLeadingWildcard': true}", new Object[0]);
        OResultSet res = this.db.query("select from cdr WHERE SEARCH_CLASS( ' RRC.20161229193002.PROD_R4.eno.data ') = true", new Object[0]);
        Assertions.assertThat((Iterator)res).hasSize(2);
        res.close();
        res = this.db.query("select from cdr WHERE SEARCH_CLASS( ' \"MDCA20MCR201612291911.277904.eno.RRC.20161229193002.PROD_R4.eno.data\" ') = true", new Object[0]);
        Assertions.assertThat((Iterator)res).hasSize(1);
        res.close();
        res = this.db.query("select from cdr WHERE SEARCH_CLASS(' MDCA* ')= true", new Object[0]);
        res.close();
        res = this.db.query("select from cdr WHERE SEARCH_CLASS(' *20MCR2016122* ') =true", new Object[0]);
        Assertions.assertThat((Iterator)res).hasSize(1);
        res.close();
    }

    @Test
    public void testHierarchy() throws Exception {
        this.db.command("CREATE Class Father EXTENDS V", new Object[0]);
        this.db.command("CREATE PROPERTY Father.text STRING", new Object[0]);
        this.db.command("CREATE INDEX Father.text ON Father(text) FULLTEXT ENGINE LUCENE ", new Object[0]);
        this.db.command("CREATE Class Son EXTENDS Father", new Object[0]);
        this.db.command("CREATE PROPERTY Son.textOfSon STRING", new Object[0]);
        this.db.command("CREATE INDEX Son.textOfSon ON Son(textOfSon) FULLTEXT ENGINE LUCENE ", new Object[0]);
        OClass father = this.db.getMetadata().getSchema().getClass("Father");
    }

    @Test
    public void documentSertest() throws Exception {
        Document doc = new Document();
        doc.add((IndexableField)new StringField("text", "yabba dabba", Field.Store.YES));
        SimpleTextCodec codec = new SimpleTextCodec();
    }

    @Test
    public void charset() throws Exception {
        String element = ";";
        char x = element.charAt(0);
        System.out.println("x=" + x);
    }
}

