/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.integration;

import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabasePool;
import com.orientechnologies.orient.core.db.ODatabaseSession;
import com.orientechnologies.orient.core.db.OrientDB;
import com.orientechnologies.orient.core.db.OrientDBConfig;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.OServerMain;
import java.io.File;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OLuceneIndexCrashRestoreIT {
    private AtomicLong idGen;
    private ExecutorService executorService;
    private Process serverProcess;
    private List<String> names;
    private List<String> surnames;
    private OrientDB orientdb;
    private ODatabasePool databasePool;

    @Before
    public void beforeMethod() throws Exception {
        this.executorService = Executors.newCachedThreadPool();
        this.idGen = new AtomicLong();
        this.spawnServer();
        this.orientdb = new OrientDB("remote:localhost:3900", "root", "root", OrientDBConfig.defaultConfig());
        this.databasePool = new ODatabasePool(this.orientdb, "testLuceneCrash", "admin", "admin");
        this.names = Arrays.asList("John", "Robert Luis", "Jane", "andrew", "Scott", "luke", "Enriquez", "Luis", "Gabriel", "Sara");
        this.surnames = Arrays.asList("Smith", "Done", "Doe", "pig", "mole", "Jones", "Candito", "Simmons", "Angel", "Low");
    }

    public void spawnServer() throws Exception {
        OLogManager.instance().installCustomFormatter();
        OGlobalConfiguration.WAL_FUZZY_CHECKPOINT_INTERVAL.setValue((Object)1000000);
        OGlobalConfiguration.RID_BAG_EMBEDDED_TO_SBTREEBONSAI_THRESHOLD.setValue((Object)3);
        OGlobalConfiguration.FILE_LOCK.setValue((Object)false);
        String buildDirectory = "./target/testLuceneCrash";
        File buildDir = new File("./target/testLuceneCrash");
        if (buildDir.exists()) {
            OFileUtils.deleteRecursively((File)buildDir);
        }
        buildDir.mkdirs();
        File mutexFile = new File(buildDir, "mutex.ct");
        RandomAccessFile mutex = new RandomAccessFile(mutexFile, "rw");
        mutex.seek(0L);
        mutex.write(0);
        String javaExec = System.getProperty("java.home") + "/bin/java";
        javaExec = new File(javaExec).getCanonicalPath();
        ProcessBuilder processBuilder = new ProcessBuilder(javaExec, "-Xmx2048m", "-classpath", System.getProperty("java.class.path"), "-DmutexFile=" + mutexFile.getAbsolutePath(), "-DORIENTDB_HOME=./target/testLuceneCrash", RemoteDBRunner.class.getName());
        processBuilder.inheritIO();
        this.serverProcess = processBuilder.start();
        boolean started = false;
        do {
            System.out.println(": Wait for server start");
            TimeUnit.SECONDS.sleep(5L);
            mutex.seek(0L);
        } while (!(started = mutex.read() == 1));
        mutex.close();
        mutexFile.delete();
        System.out.println(": Server was started");
    }

    @After
    public void tearDown() {
        File buildDir = new File("./target/databases");
        OFileUtils.deleteRecursively((File)buildDir);
        Assert.assertFalse((boolean)buildDir.exists());
        this.orientdb.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEntriesAddition() throws Exception {
        OResultSet res;
        ODatabaseSession db;
        ArrayList<DataPropagationTask> futures = new ArrayList();
        try {
            this.createSchema(this.databasePool);
            for (int i = 0; i < 1; ++i) {
                System.out.println("Start data propagation ::" + i);
                futures = this.startLoaders();
                System.out.println("Wait for 1 minutes");
                TimeUnit.MINUTES.sleep(1L);
                System.out.println("Stop loaders");
                this.stopLoaders(futures);
                System.out.println("Wait for 30 seconds");
                TimeUnit.SECONDS.sleep(30L);
                db = this.databasePool.acquire();
                res = db.query("select from Person where name lucene 'Robert' ", new Object[0]);
                Assertions.assertThat((Iterator)res).hasSize(0);
                res.close();
                res = db.query("select from Person where name lucene 'Robert Luis' LIMIT 20", new Object[0]);
                Assertions.assertThat((Iterator)res).hasSize(20);
                res.close();
                db.close();
                System.out.println("END data propagation ::" + i);
            }
        }
        finally {
            this.serverProcess.destroyForcibly();
            this.serverProcess.waitFor();
        }
        System.out.println("Process was CRASHED");
        System.out.println("stop loaders");
        this.stopLoaders(futures);
        System.out.println("All loaders done");
        System.out.println("START AGAIN");
        OServer server = OServerMain.create((boolean)false);
        InputStream conf = RemoteDBRunner.class.getResourceAsStream("index-crash-config.xml");
        server.startup(conf);
        server.activate();
        while (!server.isActive()) {
            System.out.println("server active = " + server.isActive());
            TimeUnit.SECONDS.sleep(1L);
        }
        db = this.databasePool.acquire();
        db.getMetadata().reload();
        OIndex index = db.getMetadata().getIndexManager().getIndex("Person.name");
        Assertions.assertThat((Comparable)index).isNotNull();
        Assertions.assertThat((Iterable)index.getMetadata()).isNotNull();
        Assertions.assertThat((String)((String)index.getMetadata().field("default"))).isNotNull();
        Assertions.assertThat((String)((String)index.getMetadata().field("default"))).isEqualTo((Object)"org.apache.lucene.analysis.core.KeywordAnalyzer");
        Assertions.assertThat((String)((String)index.getMetadata().field("unknownKey"))).isEqualTo((Object)"unknownValue");
        res = db.query("select from Person where name lucene 'Robert' ", new Object[0]);
        Assertions.assertThat((Iterator)res).hasSize(0);
        res.close();
        res = db.query("select from Person where name lucene 'Robert Luis' LIMIT 20", new Object[0]);
        Assertions.assertThat((Iterator)res).hasSize(20);
        res.close();
        db.close();
        server.shutdown();
    }

    private void stopLoaders(List<DataPropagationTask> futures) {
        for (DataPropagationTask future : futures) {
            future.stop();
        }
    }

    private List<DataPropagationTask> startLoaders() {
        ArrayList<DataPropagationTask> futures = new ArrayList<DataPropagationTask>();
        for (int i = 0; i < 4; ++i) {
            DataPropagationTask loader = new DataPropagationTask(this.databasePool);
            this.executorService.submit(loader);
            futures.add(loader);
        }
        return futures;
    }

    private void createSchema(ODatabasePool pool) {
        ODatabaseSession db = pool.acquire();
        System.out.println("create index for db:: " + db.getURL());
        db.command("Create class Person", new Object[0]);
        db.command("Create property Person.name STRING", new Object[0]);
        db.command("Create property Person.surname STRING", new Object[0]);
        db.command("Create index Person.name on Person(name) FULLTEXT ENGINE LUCENE METADATA {'default':'org.apache.lucene.analysis.core.KeywordAnalyzer', 'unknownKey':'unknownValue'}", new Object[0]);
        db.command("Create index Person.surname on Person(surname) FULLTEXT ENGINE LUCENE METADATA {'default':'org.apache.lucene.analysis.core.KeywordAnalyzer', 'unknownKey':'unknownValue'}", new Object[0]);
        db.getMetadata().getIndexManager().reload();
        System.out.println(db.getMetadata().getIndexManager().getIndex("Person.name").getConfiguration().toJSON());
        db.close();
    }

    public class DataPropagationTask
    implements Callable<Void> {
        private final ODatabasePool pool;
        private volatile boolean stop = false;

        public DataPropagationTask(ODatabasePool pool) {
            this.pool = pool;
        }

        public void stop() {
            this.stop = true;
        }

        @Override
        public Void call() throws Exception {
            ODatabaseSession testDB = null;
            try {
                testDB = this.pool.acquire();
                while (!this.stop) {
                    long id = OLuceneIndexCrashRestoreIT.this.idGen.getAndIncrement();
                    long ts = System.currentTimeMillis();
                    if (id % 1000L == 0L) {
                        System.out.println(Thread.currentThread().getName() + " inserted:: " + id);
                        testDB.commit();
                    }
                    if (id % 2000L == 0L) {
                        OResultSet resultSet = testDB.command("delete from Person where name lucene 'Robert' ", new Object[0]);
                        System.out.println(Thread.currentThread().getName() + " deleted:: " + resultSet.next().getProperty("count"));
                        testDB.commit();
                    }
                    int nameIdx = (int)(id % (long)OLuceneIndexCrashRestoreIT.this.names.size());
                    for (int i = 0; i < 10; ++i) {
                        String insert;
                        if (id % 1000L == 0L) {
                            insert = "insert into person (name) values ('" + (String)OLuceneIndexCrashRestoreIT.this.names.get(nameIdx) + "')";
                            testDB.command(insert, new Object[0]).close();
                            continue;
                        }
                        insert = "insert into person (name,surname) values ('" + (String)OLuceneIndexCrashRestoreIT.this.names.get(nameIdx) + "','" + (String)OLuceneIndexCrashRestoreIT.this.surnames.get(nameIdx) + "')";
                        testDB.command(insert, new Object[0]).close();
                    }
                }
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                if (testDB != null && !testDB.isClosed()) {
                    testDB.close();
                }
            }
            return null;
        }
    }

    public static final class RemoteDBRunner {
        public static void main(String[] args) throws Exception {
            OGlobalConfiguration.RID_BAG_EMBEDDED_TO_SBTREEBONSAI_THRESHOLD.setValue((Object)3);
            OGlobalConfiguration.WAL_FUZZY_CHECKPOINT_INTERVAL.setValue((Object)100000000);
            OServer server = OServerMain.create();
            InputStream conf = RemoteDBRunner.class.getResourceAsStream("index-crash-config.xml");
            OLogManager.instance().installCustomFormatter();
            server.startup(conf);
            server.activate();
            String mutexFile = System.getProperty("mutexFile");
            RandomAccessFile mutex = new RandomAccessFile(mutexFile, "rw");
            mutex.seek(0L);
            mutex.write(1);
            mutex.close();
        }
    }
}

