/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.index;

import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.lucene.test.BaseLuceneTest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.script.OCommandScript;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.logging.Level;
import org.apache.lucene.analysis.en.EnglishAnalyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class OLuceneAllIndexTest
extends BaseLuceneTest {
    @Before
    public void init() throws IOException {
        OLogManager.instance().installCustomFormatter();
        OLogManager.instance().setConsoleLevel(Level.INFO.getName());
        System.setProperty("orientdb.test.env", "ci");
        String fromStream = OIOUtils.readStreamAsString((InputStream)ClassLoader.getSystemResourceAsStream("testLuceneIndex.sql"));
        this.db.command((OCommandRequest)new OCommandScript("sql", fromStream)).execute(new Object[0]);
        this.db.setProperty("CUSTOM", (Object)"strictSql=false");
        this.db.command((OCommandRequest)new OCommandSQL("create index Song.title on Song (title) FULLTEXT ENGINE LUCENE METADATA {\"index_analyzer\":\"" + StandardAnalyzer.class.getName() + "\"}")).execute(new Object[0]);
        this.db.command((OCommandRequest)new OCommandSQL("create index Song.author on Song (author) FULLTEXT ENGINE LUCENE METADATA {\"index_analyzer\":\"" + StandardAnalyzer.class.getName() + "\"}")).execute(new Object[0]);
        this.db.command((OCommandRequest)new OCommandSQL("create index Song.lyrics on Song (lyrics) FULLTEXT ENGINE LUCENE METADATA {\"index_analyzer\":\"" + EnglishAnalyzer.class.getName() + "\"}")).execute(new Object[0]);
    }

    @Test
    @Ignore
    public void testLuceneFunction() throws Exception {
        List docs = this.db.query((OQuery)new OSQLSynchQuery("select from Song where lucene_match( \"Song.author:Fabbio\" ) = true "), new Object[0]);
        Assertions.assertThat((List)docs).hasSize(87);
    }
}

