/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.functions;

import com.orientechnologies.lucene.test.BaseLuceneTest;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.io.InputStream;
import java.util.Iterator;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class OLuceneSearchOnIndexFunctionTest
extends BaseLuceneTest {
    @Before
    public void setUp() throws Exception {
        InputStream stream = ClassLoader.getSystemResourceAsStream("testLuceneIndex.sql");
        this.db.execute("sql", this.getScriptFromStream(stream), new Object[0]);
        this.db.command("create index Song.title on Song (title) FULLTEXT ENGINE LUCENE ", new Object[0]);
        this.db.command("create index Song.author on Song (author) FULLTEXT ENGINE LUCENE ", new Object[0]);
        this.db.command("create index Author.name on Author (name) FULLTEXT ENGINE LUCENE ", new Object[0]);
        this.db.command("create index Song.lyrics_description on Song (lyrics,description) FULLTEXT ENGINE LUCENE ", new Object[0]);
    }

    @Test
    public void shouldSearchOnSingleIndex() throws Exception {
        OResultSet resultSet = this.db.query("SELECT from Song where SEARCH_INDEX('Song.title', 'BELIEVE') = true", new Object[0]);
        Assertions.assertThat((Iterator)resultSet).hasSize(2);
        resultSet.close();
        resultSet = this.db.query("SELECT from Song where SEARCH_INDEX('Song.title', \"bel*\") = true", new Object[0]);
        Assertions.assertThat((Iterator)resultSet).hasSize(3);
        resultSet.close();
        resultSet = this.db.query("SELECT from Song where SEARCH_INDEX('Song.title', 'bel*') = true", new Object[0]);
        Assertions.assertThat((Iterator)resultSet).hasSize(3);
        resultSet.close();
    }

    @Test
    public void shouldFindNothingOnEmptyQuery() throws Exception {
        OResultSet resultSet = this.db.query("SELECT from Song where SEARCH_INDEX('Song.title', '') = true", new Object[0]);
        Assertions.assertThat((Iterator)resultSet).hasSize(0);
        resultSet.close();
    }

    @Test
    public void shouldSearchOnSingleIndexWithLeadingWildcard() throws Exception {
        OResultSet resultSet = this.db.query("SELECT from Song where SEARCH_INDEX('Song.title', '*EVE*', {'allowLeadingWildcard': true}) = true", new Object[0]);
        Assertions.assertThat((Iterator)resultSet).hasSize(14);
        resultSet.close();
    }

    @Test
    public void shouldSearchOnTwoIndexesInOR() throws Exception {
        OResultSet resultSet = this.db.query("SELECT from Song where SEARCH_INDEX('Song.title', 'BELIEVE') = true OR SEARCH_INDEX('Song.author', 'Bob') = true ", new Object[0]);
        Assertions.assertThat((Iterator)resultSet).hasSize(41);
        resultSet.close();
    }

    @Test
    public void shouldSearhOnTwoIndexesInAND() throws Exception {
        OResultSet resultSet = this.db.query("SELECT from Song where SEARCH_INDEX('Song.title', 'tambourine') = true AND SEARCH_INDEX('Song.author', 'Bob') = true ", new Object[0]);
        Assertions.assertThat((Iterator)resultSet).hasSize(1);
        resultSet.close();
    }

    @Test
    public void shouldSearhOnTwoIndexesWithLeadingWildcardInAND() throws Exception {
        OResultSet resultSet = this.db.query("SELECT from Song where SEARCH_INDEX('Song.title', 'tambourine') = true AND SEARCH_INDEX('Song.author', 'Bob', {'allowLeadingWildcard': true}) = true ", new Object[0]);
        Assertions.assertThat((Iterator)resultSet).hasSize(1);
        resultSet.close();
    }

    @Test(expected=OCommandExecutionException.class)
    public void shouldFailWithWrongIndexName() throws Exception {
        this.db.query("SELECT from Song where SEARCH_INDEX('Song.wrongName', 'tambourine') = true ", new Object[0]).close();
    }
}

