/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.functions;

import com.orientechnologies.lucene.test.BaseLuceneTest;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class OLuceneSearchOnFieldsFunctionTest
extends BaseLuceneTest {
    @Before
    public void setUp() throws Exception {
        InputStream stream = ClassLoader.getSystemResourceAsStream("testLuceneIndex.sql");
        this.db.execute("sql", this.getScriptFromStream(stream), new Object[0]);
        this.db.command("create index Song.title on Song (title) FULLTEXT ENGINE LUCENE ", new Object[0]);
        this.db.command("create index Song.author on Song (author) FULLTEXT ENGINE LUCENE ", new Object[0]);
        this.db.command("create index Song.lyrics_description on Song (lyrics,description) FULLTEXT ENGINE LUCENE ", new Object[0]);
    }

    @Test
    public void shouldSearchOnSingleField() throws Exception {
        OResultSet resultSet = this.db.query("SELECT from Song where SEARCH_FIELDS(['title'], 'BELIEVE') = true", new Object[0]);
        Assertions.assertThat((Iterator)resultSet).hasSize(2);
        resultSet.close();
    }

    @Test
    public void shouldSearchOnSingleFieldWithLeadingWildcard() throws Exception {
        OResultSet resultSet = this.db.query("SELECT from Song where SEARCH_INDEX('Song.title', '*EVE*', {'allowLeadingWildcard': true}) = true", new Object[0]);
        Assertions.assertThat((Iterator)resultSet).hasSize(14);
        resultSet.close();
    }

    @Test
    public void shouldSearhOnTwoFieldsInOR() throws Exception {
        OResultSet resultSet = this.db.query("SELECT from Song where SEARCH_FIELDS(['title'], 'BELIEVE') = true OR SEARCH_FIELDS(['author'], 'Bob') = true ", new Object[0]);
        Assertions.assertThat((Iterator)resultSet).hasSize(41);
        resultSet.close();
    }

    @Test
    public void shouldSearhOnTwoFieldsInAND() throws Exception {
        OResultSet resultSet = this.db.query("SELECT from Song where SEARCH_FIELDS(['title'], 'tambourine') = true AND SEARCH_FIELDS(['author'], 'Bob') = true ", new Object[0]);
        Assertions.assertThat((Iterator)resultSet).hasSize(1);
        resultSet.close();
    }

    @Test
    public void shouldSearhOnTwoFieldsWithLeadingWildcardInAND() throws Exception {
        OResultSet resultSet = this.db.query("SELECT from Song where SEARCH_FIELDS(['title'], 'tambourine') = true AND SEARCH_FIELDS(['author'], 'Bob', {'allowLeadingWildcard': true}) = true ", new Object[0]);
        Assertions.assertThat((Iterator)resultSet).hasSize(1);
        resultSet.close();
    }

    @Test
    public void shouldSearchOnMultiFieldIndex() throws Exception {
        OResultSet resultSet = this.db.query("SELECT from Song where SEARCH_FIELDS(['lyrics','description'], '(description:happiness) (lyrics:sad)  ') = true ", new Object[0]);
        Assertions.assertThat((Iterator)resultSet).hasSize(2);
        resultSet.close();
        resultSet = this.db.query("SELECT from Song where SEARCH_FIELDS(['description','lyrics'], '(description:happiness) (lyrics:sad)  ') = true ", new Object[0]);
        Assertions.assertThat((Iterator)resultSet).hasSize(2);
        resultSet.close();
        resultSet = this.db.query("SELECT from Song where SEARCH_FIELDS(['description'], '(description:happiness) (lyrics:sad)  ') = true ", new Object[0]);
        Assertions.assertThat((Iterator)resultSet).hasSize(2);
        resultSet.close();
    }

    @Test(expected=OCommandExecutionException.class)
    public void shouldFailWithWrongFieldName() throws Exception {
        this.db.query("SELECT from Song where SEARCH_FIELDS(['wrongName'], '(description:happiness) (lyrics:sad)  ') = true ", new Object[0]);
    }

    @Test
    public void shouldSearchWithHesitance() throws Exception {
        this.db.command("create class RockSong extends Song", new Object[0]);
        this.db.command("create vertex RockSong set title=\"This is only rock\", author=\"A cool rocker\"", new Object[0]);
        OResultSet resultSet = this.db.query("SELECT from RockSong where SEARCH_FIELDS(['title'], '+only +rock') = true ", new Object[0]);
        Assertions.assertThat((Iterator)resultSet).hasSize(1);
        resultSet.close();
    }

    @Test
    public void testSquareBrackets() throws Exception {
        String className = "testSquareBrackets";
        String classNameE = "testSquareBracketsE";
        this.db.command("create class " + className + " extends V;", new Object[0]);
        this.db.command("create property " + className + ".id Integer;", new Object[0]);
        this.db.command("create property " + className + ".name String;", new Object[0]);
        this.db.command("CREATE INDEX " + className + ".name ON " + className + "(name) FULLTEXT ENGINE LUCENE;", new Object[0]);
        this.db.command("CREATE CLASS " + classNameE + " EXTENDS E", new Object[0]);
        this.db.command("insert into " + className + " set id = 1, name = 'A';", new Object[0]);
        this.db.command("insert into " + className + " set id = 2, name = 'AB';", new Object[0]);
        this.db.command("insert into " + className + " set id = 3, name = 'ABC';", new Object[0]);
        this.db.command("insert into " + className + " set id = 4, name = 'ABCD';", new Object[0]);
        this.db.command("CREATE EDGE " + classNameE + " FROM (SELECT FROM " + className + " WHERE id = 1) to (SELECT FROM " + className + " WHERE id IN [2, 3, 4]);", new Object[0]);
        OResultSet result = this.db.query("SELECT out('" + classNameE + "')[SEARCH_FIELDS(['name'], 'A*') = true] as theList FROM " + className + " WHERE id = 1;", new Object[0]);
        Assertions.assertThat((boolean)result.hasNext());
        OResult item = result.next();
        Assertions.assertThat((Object)item.getProperty("theList")).isInstanceOf(List.class);
        Assertions.assertThat((List)((List)item.getProperty("theList"))).hasSize(3);
        result.close();
    }
}

