/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.functions;

import com.orientechnologies.lucene.tests.OLuceneBaseTest;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.io.InputStream;
import java.util.Iterator;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class OLuceneSearchOnClassFunctionTest
extends OLuceneBaseTest {
    @Before
    public void setUp() throws Exception {
        InputStream stream = ClassLoader.getSystemResourceAsStream("testLuceneIndex.sql");
        this.db.execute("sql", this.getScriptFromStream(stream), new Object[0]);
        this.db.command("create index Song.title on Song (title) FULLTEXT ENGINE LUCENE ", new Object[0]);
    }

    @Test
    public void shouldSearchOnClass() throws Exception {
        OResultSet resultSet = this.db.query("SELECT from Song where SEARCH_Class('BELIEVE') = true", new Object[0]);
        Assertions.assertThat((Iterator)resultSet).hasSize(2);
        resultSet.close();
    }

    @Test
    public void shouldSearchOnSingleFieldWithLeadingWildcard() throws Exception {
        OResultSet resultSet = this.db.query("SELECT from Song where SEARCH_CLASS( '*EVE*', {'allowLeadingWildcard': true}) = true", new Object[0]);
        Assertions.assertThat((Iterator)resultSet).hasSize(14);
        resultSet.close();
    }

    @Test
    public void shouldSearchInOr() throws Exception {
        OResultSet resultSet = this.db.query("SELECT from Song where SEARCH_CLASS('BELIEVE') = true OR SEARCH_CLASS('GOODNIGHT') = true ", new Object[0]);
        Assertions.assertThat((Iterator)resultSet).hasSize(5);
        resultSet.close();
    }

    @Test
    public void shouldSearchInAnd() throws Exception {
        OResultSet resultSet = this.db.query("SELECT from Song where SEARCH_CLASS('GOODNIGHT') = true AND SEARCH_CLASS( 'Irene', {'allowLeadingWildcard': true}) = true ", new Object[0]);
        Assertions.assertThat((Iterator)resultSet).hasSize(1);
        resultSet.close();
    }

    @Test(expected=OCommandExecutionException.class)
    public void shouldThrowExceptionWithWrongClass() throws Exception {
        OResultSet resultSet = this.db.query("SELECT from Author where SEARCH_CLASS('(description:happiness) (lyrics:sad)  ') = true ", new Object[0]);
        resultSet.close();
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionIfMoreIndexesAreDefined() {
        this.db.command("create index Song.author on Song (author) FULLTEXT ENGINE LUCENE ", new Object[0]);
        OResultSet resultSet = this.db.query("SELECT from Song where SEARCH_CLASS('not important, will fail') = true ", new Object[0]);
        resultSet.close();
    }

    @Test
    public void shouldHighlightTitle() throws Exception {
        OResultSet resultSet = this.db.query("SELECT title, $title_hl from Song where SEARCH_CLASS('believe', {highlight: { fields: ['title'], 'start': '<span>', 'end': '</span>' } }) = true ", new Object[0]);
        resultSet.stream().forEach(r -> Assertions.assertThat((String)((String)r.getProperty("$title_hl"))).containsIgnoringCase((CharSequence)"<span>believe</span>"));
        resultSet.close();
    }
}

