/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.functions;

import com.orientechnologies.lucene.test.BaseLuceneTest;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.io.InputStream;
import java.util.Iterator;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class OLuceneSearchMoreLikeThisFunctionTest
extends BaseLuceneTest {
    @Before
    public void setUp() throws Exception {
        try (InputStream stream = ClassLoader.getSystemResourceAsStream("testLuceneIndex.sql");){
            this.db.execute("sql", this.getScriptFromStream(stream), new Object[0]).close();
        }
    }

    @Test
    public void shouldSearchMoreLikeThisWithRid() throws Exception {
        this.db.command("create index Song.title on Song (title) FULLTEXT ENGINE LUCENE ", new Object[0]);
        OClass clazz = this.db.getMetadata().getSchema().getClass("Song");
        int defCluster = clazz.getDefaultClusterId();
        try (OResultSet resultSet = this.db.query("SELECT from Song where SEARCH_More([#" + defCluster + ":2, #" + defCluster + ":3],{'minTermFreq':1, 'minDocFreq':1} ) = true", new Object[0]);){
            Assertions.assertThat((Iterator)resultSet).hasSize(48);
        }
    }

    @Test
    public void shouldSearchMoreLikeThisWithRidOnMultiFieldsIndex() throws Exception {
        this.db.command("create index Song.multi on Song (title,author) FULLTEXT ENGINE LUCENE ", new Object[0]);
        OClass clazz = this.db.getMetadata().getSchema().getClass("Song");
        int defCluster = clazz.getDefaultClusterId();
        try (OResultSet resultSet = this.db.query("SELECT from Song where SEARCH_More([#" + defCluster + ":2, #" + defCluster + ":3] , {'minTermFreq':1, 'minDocFreq':1} ) = true", new Object[0]);){
            Assertions.assertThat((Iterator)resultSet).hasSize(84);
        }
    }

    @Test
    public void shouldSearchOnFieldAndMoreLikeThisWithRidOnMultiFieldsIndex() throws Exception {
        this.db.command("create index Song.multi on Song (title) FULLTEXT ENGINE LUCENE ", new Object[0]);
        OClass clazz = this.db.getMetadata().getSchema().getClass("Song");
        int defCluster = clazz.getDefaultClusterId();
        try (OResultSet resultSet = this.db.query("SELECT from Song where author ='Hunter' AND SEARCH_More([#" + defCluster + ":2, #" + defCluster + ":3,#" + defCluster + ":4,#" + defCluster + ":5],{'minTermFreq':1, 'minDocFreq':1} ) = true", new Object[0]);){
            Assertions.assertThat((Iterator)resultSet).hasSize(8);
        }
    }

    @Test
    public void shouldSearchOnFieldOrMoreLikeThisWithRidOnMultiFieldsIndex() throws Exception {
        this.db.command("create index Song.multi on Song (title) FULLTEXT ENGINE LUCENE ", new Object[0]);
        OClass clazz = this.db.getMetadata().getSchema().getClass("Song");
        int defCluster = clazz.getDefaultClusterId();
        try (OResultSet resultSet = this.db.query("SELECT from Song where SEARCH_More([#" + defCluster + ":2, #" + defCluster + ":3], {'minTermFreq':1, 'minDocFreq':1} ) = true OR author ='Hunter' ", new Object[0]);){
            resultSet.getExecutionPlan().ifPresent(c -> System.out.println(c.prettyPrint(1, 1)));
            Assertions.assertThat((Iterator)resultSet).hasSize(138);
        }
    }

    @Test
    public void shouldSearchMoreLikeThisWithRidOnMultiFieldsIndexWithMetadata() throws Exception {
        this.db.command("create index Song.multi on Song (title,author) FULLTEXT ENGINE LUCENE ", new Object[0]);
        OClass clazz = this.db.getMetadata().getSchema().getClass("Song");
        int defCluster = clazz.getDefaultClusterId();
        try (OResultSet resultSet = this.db.query("SELECT from Song where SEARCH_More( [#" + defCluster + ":2, #" + defCluster + ":3] , {'fields': [ 'title' ], 'minTermFreq':1, 'minDocFreq':1}) = true", new Object[0]);){
            resultSet.getExecutionPlan().ifPresent(c -> System.out.println(c.prettyPrint(1, 1)));
            Assertions.assertThat((Iterator)resultSet).hasSize(84);
        }
    }

    @Test
    public void shouldSearchMoreLikeThisWithInnerQuery() throws Exception {
        this.db.command("create index Song.multi on Song (title,author) FULLTEXT ENGINE LUCENE ", new Object[0]);
        try (OResultSet resultSet = this.db.query("SELECT from Song  let $a=(SELECT @rid FROM Song WHERE author = 'Hunter')  where SEARCH_More( $a, { 'minTermFreq':1, 'minDocFreq':1} ) = true", new Object[0]);){
            Assertions.assertThat((Iterator)resultSet).hasSize(229);
        }
    }
}

