/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.engine;

import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.lucene.engine.OLuceneIndexWriterFactory;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.io.File;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.LiveIndexWriterConfig;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class OLuceneIndexWriterFactoryTest {
    @Test
    public void shouldCreateIndexWriterConfiguredWithMetadataValues() throws Exception {
        OLuceneIndexWriterFactory fc = new OLuceneIndexWriterFactory();
        ODocument meta = new ODocument().fromJSON(OIOUtils.readFileAsString((File)new File("./src/test/resources/index_metadata_new.json")));
        IndexWriter writer = fc.createIndexWriter((Directory)new RAMDirectory(), meta, (Analyzer)new StandardAnalyzer());
        LiveIndexWriterConfig config = writer.getConfig();
        Assertions.assertThat((boolean)config.getUseCompoundFile()).isFalse();
        Assertions.assertThat((Object)config.getAnalyzer()).isInstanceOf(StandardAnalyzer.class);
        Assertions.assertThat((int)config.getMaxBufferedDocs()).isEqualTo(-1);
        Assertions.assertThat((int)config.getRAMPerThreadHardLimitMB()).isEqualTo(1024);
    }
}

