/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.engine;

import com.orientechnologies.lucene.engine.OLuceneIndexEngineUtils;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.search.SortField;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class OLuceneIndexEngineUtilsTest {
    @Test
    public void buildSortFields() throws Exception {
        ODocument metadata = new ODocument().field("sort", Arrays.asList(new ODocument().field("field", (Object)"score").field("reverse", (Object)false).field("type", (Object)"INT").toMap()));
        List fields = OLuceneIndexEngineUtils.buildSortFields((ODocument)metadata);
        Assertions.assertThat((List)fields).hasSize(1);
        SortField sortField = (SortField)fields.get(0);
        Assertions.assertThat((String)sortField.getField()).isEqualTo((Object)"score");
        Assertions.assertThat((Comparable)sortField.getType()).isEqualTo((Object)SortField.Type.INT);
        Assertions.assertThat((boolean)sortField.getReverse()).isFalse();
    }

    @Test
    public void buildIntSortField() throws Exception {
        ODocument sortConf = new ODocument().field("field", (Object)"score").field("reverse", (Object)true).field("type", (Object)"INT");
        SortField sortField = OLuceneIndexEngineUtils.buildSortField((ODocument)sortConf);
        Assertions.assertThat((String)sortField.getField()).isEqualTo((Object)"score");
        Assertions.assertThat((Comparable)sortField.getType()).isEqualTo((Object)SortField.Type.INT);
        Assertions.assertThat((boolean)sortField.getReverse()).isTrue();
    }

    @Test
    public void buildDocSortField() throws Exception {
        ODocument sortConf = new ODocument().field("type", (Object)"DOC");
        SortField sortField = OLuceneIndexEngineUtils.buildSortField((ODocument)sortConf);
        Assertions.assertThat((String)sortField.getField()).isNull();
        Assertions.assertThat((Comparable)sortField.getType()).isEqualTo((Object)SortField.Type.DOC);
        Assertions.assertThat((boolean)sortField.getReverse()).isFalse();
    }
}

