/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.engine;

import com.orientechnologies.lucene.engine.OLuceneDirectoryFactory;
import com.orientechnologies.lucene.test.BaseLuceneTest;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.io.File;
import java.util.Collections;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.MMapDirectory;
import org.apache.lucene.store.NIOFSDirectory;
import org.apache.lucene.store.RAMDirectory;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class OLuceneDirectoryFactoryTest
extends BaseLuceneTest {
    private OLuceneDirectoryFactory fc;
    private ODocument meta;
    private OIndexDefinition indexDef;

    @Before
    public void setUp() throws Exception {
        this.meta = new ODocument();
        this.indexDef = (OIndexDefinition)Mockito.mock(OIndexDefinition.class);
        Mockito.when((Object)this.indexDef.getFields()).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.indexDef.getClassName()).thenReturn((Object)"Song");
        this.fc = new OLuceneDirectoryFactory();
    }

    @Test
    public void shouldCreateNioFsDirectory() throws Exception {
        this.meta.field("directory_type", (Object)"nio");
        ODatabaseDocumentTx db = this.dropOrCreate("plocal:./target/testDatabase/" + this.name.getMethodName(), true);
        Directory directory = this.fc.createDirectory((ODatabaseDocumentInternal)db, "index.name", this.meta);
        Assertions.assertThat((Object)directory).isInstanceOf(NIOFSDirectory.class);
        Assertions.assertThat((File)new File("./target/testDatabase/" + this.name.getMethodName() + "/luceneIndexes/index.name")).exists();
        db.drop();
    }

    @Test
    public void shouldCreateMMapFsDirectory() throws Exception {
        this.meta.field("directory_type", (Object)"mmap");
        ODatabaseDocumentTx db = this.dropOrCreate("plocal:./target/testDatabase/" + this.name.getMethodName(), true);
        Directory directory = this.fc.createDirectory((ODatabaseDocumentInternal)db, "index.name", this.meta);
        Assertions.assertThat((Object)directory).isInstanceOf(MMapDirectory.class);
        Assertions.assertThat((File)new File("./target/testDatabase/" + this.name.getMethodName() + "/luceneIndexes/index.name")).exists();
        db.drop();
    }

    @Test
    public void shouldCreateRamDirectory() throws Exception {
        this.meta.field("directory_type", (Object)"ram");
        ODatabaseDocumentTx db = this.dropOrCreate("plocal:./target/testDatabase/" + this.name.getMethodName(), true);
        Directory directory = this.fc.createDirectory((ODatabaseDocumentInternal)db, "index.name", this.meta);
        Assertions.assertThat((Object)directory).isInstanceOf(RAMDirectory.class);
        db.drop();
    }

    @Test
    public void shouldCreateRamDirectoryOnMemoryDatabase() throws Exception {
        this.meta.field("directory_type", (Object)"mmap");
        ODatabaseDocumentTx db = this.dropOrCreate("memory:" + this.name.getMethodName(), true);
        Directory directory = this.fc.createDirectory((ODatabaseDocumentInternal)db, "index.name", this.meta);
        Assertions.assertThat((Object)directory).isInstanceOf(RAMDirectory.class);
    }
}

