/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.analyzer;

import com.orientechnologies.lucene.analyzer.OLucenePerFieldAnalyzerWrapper;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.en.EnglishAnalyzer;
import org.apache.lucene.analysis.it.ItalianAnalyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class OLucenePerFieldAnalyzerWrapperTest {
    @Test
    public void shouldReturnDefaultAnalyzerForEachField() throws Exception {
        OLucenePerFieldAnalyzerWrapper analyzer = new OLucenePerFieldAnalyzerWrapper((Analyzer)new StandardAnalyzer());
        Assertions.assertThat((Object)analyzer.getWrappedAnalyzer("a_field")).isNotNull();
        Assertions.assertThat((Object)analyzer.getWrappedAnalyzer("a_field")).isInstanceOf(StandardAnalyzer.class);
    }

    @Test
    public void shouldReturnCustomAnalyzerForEachField() throws Exception {
        OLucenePerFieldAnalyzerWrapper analyzer = new OLucenePerFieldAnalyzerWrapper((Analyzer)new StandardAnalyzer());
        analyzer.add("text_en", (Analyzer)new EnglishAnalyzer());
        analyzer.add("text_it", (Analyzer)new ItalianAnalyzer());
        Assertions.assertThat((Object)analyzer.getWrappedAnalyzer("text_en")).isNotNull();
        Assertions.assertThat((Object)analyzer.getWrappedAnalyzer("text_en")).isInstanceOf(EnglishAnalyzer.class);
        Assertions.assertThat((Object)analyzer.getWrappedAnalyzer("text_it")).isNotNull();
        Assertions.assertThat((Object)analyzer.getWrappedAnalyzer("text_it")).isInstanceOf(ItalianAnalyzer.class);
    }

    @Test
    public void shouldReturnCustomAnalyzerForEachFieldInitializedByConstructor() throws Exception {
        OLucenePerFieldAnalyzerWrapper analyzer = new OLucenePerFieldAnalyzerWrapper((Analyzer)new StandardAnalyzer(), (Map)new HashMap<String, Analyzer>(){
            {
                this.put("text_en", new EnglishAnalyzer());
                this.put("text_it", new ItalianAnalyzer());
            }
        });
        Assertions.assertThat((Object)analyzer.getWrappedAnalyzer("text_en")).isNotNull();
        Assertions.assertThat((Object)analyzer.getWrappedAnalyzer("text_en")).isInstanceOf(EnglishAnalyzer.class);
        Assertions.assertThat((Object)analyzer.getWrappedAnalyzer("text_it")).isNotNull();
        Assertions.assertThat((Object)analyzer.getWrappedAnalyzer("text_it")).isInstanceOf(ItalianAnalyzer.class);
    }
}

