/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.analyzer;

import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.lucene.analyzer.OLuceneAnalyzerFactory;
import com.orientechnologies.lucene.analyzer.OLucenePerFieldAnalyzerWrapper;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.analysis.StopwordAnalyzerBase;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.analysis.en.EnglishAnalyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class OLuceneAnalyzerFactoryTest {
    private OLuceneAnalyzerFactory analyzerFactory;
    private ODocument metadata;
    private OIndexDefinition indexDef;

    @Before
    public void before() throws IOException {
        this.analyzerFactory = new OLuceneAnalyzerFactory();
        String metajson = OIOUtils.readFileAsString((File)new File("./src/test/resources/index_metadata_new.json"));
        this.metadata = new ODocument().fromJSON(metajson);
        this.indexDef = (OIndexDefinition)Mockito.mock(OIndexDefinition.class);
        Mockito.when((Object)this.indexDef.getFields()).thenReturn(Arrays.asList("name", "title", "author", "lyrics", "genre", "description"));
        Mockito.when((Object)this.indexDef.getClassName()).thenReturn((Object)"Song");
    }

    @Test
    public void shouldAssignStandardAnalyzerForIndexingUndefined() throws Exception {
        OLucenePerFieldAnalyzerWrapper analyzer = (OLucenePerFieldAnalyzerWrapper)this.analyzerFactory.createAnalyzer(this.indexDef, OLuceneAnalyzerFactory.AnalyzerKind.INDEX, this.metadata);
        Assertions.assertThat((Object)analyzer.getWrappedAnalyzer("undefined")).isInstanceOf(StandardAnalyzer.class);
    }

    @Test
    public void shouldAssignKeywordAnalyzerForIndexing() throws Exception {
        OLucenePerFieldAnalyzerWrapper analyzer = (OLucenePerFieldAnalyzerWrapper)this.analyzerFactory.createAnalyzer(this.indexDef, OLuceneAnalyzerFactory.AnalyzerKind.INDEX, this.metadata);
        Assertions.assertThat((Object)analyzer.getWrappedAnalyzer("genre")).isInstanceOf(KeywordAnalyzer.class);
        Assertions.assertThat((Object)analyzer.getWrappedAnalyzer("Song.genre")).isInstanceOf(KeywordAnalyzer.class);
    }

    @Test
    public void shouldAssignConfiguredAnalyzerForIndexing() throws Exception {
        OLucenePerFieldAnalyzerWrapper analyzer = (OLucenePerFieldAnalyzerWrapper)this.analyzerFactory.createAnalyzer(this.indexDef, OLuceneAnalyzerFactory.AnalyzerKind.INDEX, this.metadata);
        Assertions.assertThat((Object)analyzer.getWrappedAnalyzer("title")).isInstanceOf(EnglishAnalyzer.class);
        Assertions.assertThat((Object)analyzer.getWrappedAnalyzer("Song.title")).isInstanceOf(EnglishAnalyzer.class);
        Assertions.assertThat((Object)analyzer.getWrappedAnalyzer("author")).isInstanceOf(KeywordAnalyzer.class);
        Assertions.assertThat((Object)analyzer.getWrappedAnalyzer("Song.author")).isInstanceOf(KeywordAnalyzer.class);
        Assertions.assertThat((Object)analyzer.getWrappedAnalyzer("lyrics")).isInstanceOf(EnglishAnalyzer.class);
        Assertions.assertThat((Object)analyzer.getWrappedAnalyzer("Song.lyrics")).isInstanceOf(EnglishAnalyzer.class);
        Assertions.assertThat((Object)analyzer.getWrappedAnalyzer("description")).isInstanceOf(StandardAnalyzer.class);
        Assertions.assertThat((Object)analyzer.getWrappedAnalyzer("Song.description")).isInstanceOf(StandardAnalyzer.class);
        StopwordAnalyzerBase description = (StopwordAnalyzerBase)analyzer.getWrappedAnalyzer("description");
        Assertions.assertThat((Iterable)description.getStopwordSet()).isNotEmpty();
        Assertions.assertThat((Iterable)description.getStopwordSet()).hasSize(2);
        Assertions.assertThat((boolean)description.getStopwordSet().contains((CharSequence)"the")).isTrue();
        Assertions.assertThat((boolean)description.getStopwordSet().contains((CharSequence)"is")).isTrue();
    }

    @Test
    public void shouldAssignConfiguredAnalyzerForQuery() throws Exception {
        OLucenePerFieldAnalyzerWrapper analyzer = (OLucenePerFieldAnalyzerWrapper)this.analyzerFactory.createAnalyzer(this.indexDef, OLuceneAnalyzerFactory.AnalyzerKind.QUERY, this.metadata);
        Assertions.assertThat((Object)analyzer.getWrappedAnalyzer("title")).isInstanceOf(EnglishAnalyzer.class);
        Assertions.assertThat((Object)analyzer.getWrappedAnalyzer("Song.title")).isInstanceOf(EnglishAnalyzer.class);
        Assertions.assertThat((Object)analyzer.getWrappedAnalyzer("author")).isInstanceOf(KeywordAnalyzer.class);
        Assertions.assertThat((Object)analyzer.getWrappedAnalyzer("Song.author")).isInstanceOf(KeywordAnalyzer.class);
        Assertions.assertThat((Object)analyzer.getWrappedAnalyzer("genre")).isInstanceOf(StandardAnalyzer.class);
        Assertions.assertThat((Object)analyzer.getWrappedAnalyzer("Song.genre")).isInstanceOf(StandardAnalyzer.class);
    }

    @Test
    public void shouldUseClassNameToPrefixFieldName() throws Exception {
        OLucenePerFieldAnalyzerWrapper analyzer = (OLucenePerFieldAnalyzerWrapper)this.analyzerFactory.createAnalyzer(this.indexDef, OLuceneAnalyzerFactory.AnalyzerKind.QUERY, this.metadata);
        Assertions.assertThat((Object)analyzer.getWrappedAnalyzer("Song.title")).isInstanceOf(EnglishAnalyzer.class);
        Assertions.assertThat((Object)analyzer.getWrappedAnalyzer("Song.author")).isInstanceOf(KeywordAnalyzer.class);
        Assertions.assertThat((Object)analyzer.getWrappedAnalyzer("Song.genre")).isInstanceOf(StandardAnalyzer.class);
    }
}

