/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.spring.session.serialization.pof;

import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofSerializer;
import com.tangosol.io.pof.PofWriter;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.session.MapSession;

public class MapSessionPofSerializer
implements PofSerializer {
    public void serialize(PofWriter pofWriter, Object value) throws IOException {
        MapSession mapSession = (MapSession)value;
        pofWriter.writeString(0, mapSession.getId());
        pofWriter.writeObject(1, (Object)mapSession.getCreationTime());
        pofWriter.writeObject(2, (Object)mapSession.getMaxInactiveInterval());
        pofWriter.writeObject(3, (Object)mapSession.getLastAccessedTime());
        HashMap<String, Object> sessionAttributes = new HashMap<String, Object>(mapSession.getAttributeNames().size());
        for (String attrName : mapSession.getAttributeNames()) {
            Object attrValue = mapSession.getAttribute(attrName);
            if (attrValue == null) continue;
            sessionAttributes.put(attrName, attrValue);
        }
        pofWriter.writeMap(5, sessionAttributes, String.class);
        pofWriter.writeRemainder(null);
    }

    public Object deserialize(PofReader pofReader) throws IOException {
        String id = pofReader.readString(0);
        Instant creationTime = (Instant)pofReader.readObject(1);
        Duration maxInactiveInterval = (Duration)pofReader.readObject(2);
        Instant lastAccessedTime = (Instant)pofReader.readObject(3);
        Map attributes = pofReader.readMap(5, new ConcurrentHashMap());
        pofReader.readRemainder();
        MapSession mapSession = new MapSession(id);
        mapSession.setCreationTime(creationTime);
        mapSession.setMaxInactiveInterval(maxInactiveInterval);
        mapSession.setLastAccessedTime(lastAccessedTime);
        for (Map.Entry entry : attributes.entrySet()) {
            mapSession.setAttribute((String)entry.getKey(), entry.getValue());
        }
        return mapSession;
    }
}

