/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.spring.session.serialization.pof;

import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofSerializer;
import com.tangosol.io.pof.PofWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class AuthenticationPofSerializer
implements PofSerializer {
    public void serialize(PofWriter pofWriter, Object value) throws IOException {
        UsernamePasswordAuthenticationToken authentication = (UsernamePasswordAuthenticationToken)value;
        pofWriter.writeCollection(1, authentication.getAuthorities(), SimpleGrantedAuthority.class);
        pofWriter.writeString(2, authentication.getCredentials().toString());
        pofWriter.writeObject(3, authentication.getDetails());
        pofWriter.writeObject(4, authentication.getPrincipal());
        pofWriter.writeRemainder(null);
    }

    public Object deserialize(PofReader pofReader) throws IOException {
        Collection authorities = pofReader.readCollection(1, new ArrayList());
        Object credentials = pofReader.readObject(2);
        Object details = pofReader.readObject(3);
        Object principal = pofReader.readObject(4);
        pofReader.readRemainder();
        UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken(principal, credentials, authorities);
        authentication.setDetails(details);
        return authentication;
    }
}

