/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.spring.session.events;

import com.oracle.coherence.spring.session.support.SessionDebugMessageUtils;
import com.oracle.coherence.spring.session.support.SessionEvent;
import com.tangosol.net.cache.CacheEvent;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.session.MapSession;
import org.springframework.session.Session;
import org.springframework.session.events.SessionDeletedEvent;
import org.springframework.session.events.SessionExpiredEvent;
import org.springframework.util.Assert;

public class SessionRemovedMapListener
implements MapListener<String, MapSession> {
    private static final Log logger = LogFactory.getLog(SessionRemovedMapListener.class);
    private final ApplicationEventPublisher eventPublisher;

    public SessionRemovedMapListener(ApplicationEventPublisher eventPublisher) {
        Assert.notNull((Object)eventPublisher, (String)"eventPublisher must not be null");
        this.eventPublisher = eventPublisher;
    }

    public void entryInserted(MapEvent<String, MapSession> evt) {
    }

    public void entryUpdated(MapEvent<String, MapSession> evt) {
    }

    public void entryDeleted(MapEvent<String, MapSession> event) {
        MapSession session = (MapSession)event.getOldValue();
        if (session != null) {
            if (event instanceof CacheEvent && ((CacheEvent)event).isSynthetic()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)SessionDebugMessageUtils.createSessionEventMessage(SessionEvent.EXPIRED, session));
                }
                this.eventPublisher.publishEvent((ApplicationEvent)new SessionExpiredEvent((Object)this, (Session)event.getOldValue()));
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)SessionDebugMessageUtils.createSessionEventMessage(SessionEvent.DELETED, session));
                }
                this.eventPublisher.publishEvent((ApplicationEvent)new SessionDeletedEvent((Object)this, (Session)session));
            }
        }
    }
}

