/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.spring.session.events;

import com.oracle.coherence.spring.session.support.SessionDebugMessageUtils;
import com.oracle.coherence.spring.session.support.SessionEvent;
import com.tangosol.net.events.EventDispatcher;
import com.tangosol.net.events.EventDispatcherAwareInterceptor;
import com.tangosol.net.events.EventInterceptor;
import com.tangosol.net.events.partition.cache.CacheLifecycleEventDispatcher;
import com.tangosol.net.events.partition.cache.EntryEvent;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.session.MapSession;
import org.springframework.session.Session;
import org.springframework.session.events.SessionCreatedEvent;
import org.springframework.util.Assert;

public class CoherenceSessionCreatedEventHandler
implements EventDispatcherAwareInterceptor<EntryEvent<String, MapSession>> {
    private static final Log logger = LogFactory.getLog(CoherenceSessionCreatedEventHandler.class);
    private final ApplicationEventPublisher eventPublisher;
    private String cacheName;
    private String serviceName;
    private String scopeName;

    public CoherenceSessionCreatedEventHandler(ApplicationEventPublisher eventPublisher) {
        Assert.notNull((Object)eventPublisher, (String)"eventPublisher must not be null");
        this.eventPublisher = eventPublisher;
    }

    public void introduceEventDispatcher(String sIdentifier, EventDispatcher dispatcher) {
        if (this.isApplicable(dispatcher, this.scopeName)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Adding Session EventInterceptor to EventDispatcher [Service: %s; scope: %s; cache: %s]", this.serviceName, this.scopeName, this.cacheName));
            }
            dispatcher.addEventInterceptor(sIdentifier, (EventInterceptor)this, new HashSet<EntryEvent.Type>(Arrays.asList(EntryEvent.Type.INSERTING)), true);
        }
    }

    public void onEvent(EntryEvent<String, MapSession> event) {
        MapSession session = (MapSession)event.getValue();
        if (session.getId().equals(session.getOriginalId())) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)SessionDebugMessageUtils.createSessionEventMessage(SessionEvent.CREATED, session));
            }
            this.eventPublisher.publishEvent((ApplicationEvent)new SessionCreatedEvent((Object)this, (Session)session));
        }
    }

    private boolean isApplicable(EventDispatcher dispatcher, String scopeName) {
        if (dispatcher instanceof CacheLifecycleEventDispatcher) {
            CacheLifecycleEventDispatcher cacheDispatcher = (CacheLifecycleEventDispatcher)dispatcher;
            if (scopeName == null || scopeName.equals(cacheDispatcher.getScopeName())) {
                return !(this.cacheName != null && !this.cacheName.equals(cacheDispatcher.getCacheName()) || this.serviceName != null && !this.serviceName.equals(this.removeScope(cacheDispatcher.getServiceName())));
            }
        }
        return false;
    }

    protected String removeScope(String serviceName) {
        int index = serviceName.indexOf(58);
        return index > -1 ? serviceName.substring(index + 1) : serviceName;
    }

    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    public void setScopeName(String scopeName) {
        this.scopeName = scopeName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }
}

