/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.spring.session.config.annotation.web.http;

import com.oracle.coherence.spring.session.CoherenceIndexedSessionRepository;
import com.oracle.coherence.spring.session.config.annotation.SpringSessionCoherenceInstance;
import com.oracle.coherence.spring.session.config.annotation.web.http.EnableCoherenceHttpSession;
import com.tangosol.net.Coherence;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.session.FindByIndexNameSessionRepository;
import org.springframework.session.FlushMode;
import org.springframework.session.IndexResolver;
import org.springframework.session.SaveMode;
import org.springframework.session.Session;
import org.springframework.session.SessionRepository;
import org.springframework.session.config.SessionRepositoryCustomizer;
import org.springframework.session.config.annotation.web.http.SpringHttpSessionConfiguration;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
public class CoherenceHttpSessionConfiguration
extends SpringHttpSessionConfiguration
implements ImportAware {
    private static final Log logger = LogFactory.getLog(CoherenceHttpSessionConfiguration.class);
    private Integer maxInactiveIntervalInSeconds = 1800;
    private String sessionMapName = "spring:session:sessions";
    private String coherenceSessionName;
    private FlushMode flushMode = FlushMode.ON_SAVE;
    private SaveMode saveMode = SaveMode.ON_SET_ATTRIBUTE;
    private Coherence coherence;
    private IndexResolver<Session> indexResolver;
    private List<SessionRepositoryCustomizer<CoherenceIndexedSessionRepository>> sessionRepositoryCustomizers;

    @Bean
    @DependsOn(value={"coherenceServer"})
    public FindByIndexNameSessionRepository<?> sessionRepository() {
        return this.createCoherenceIndexedSessionRepository();
    }

    @Autowired
    public void setCoherence(@SpringSessionCoherenceInstance ObjectProvider<Coherence> springSessionCoherenceInstance, ObjectProvider<Coherence> coherenceInstance) {
        Coherence coherenceInstanceToUse = (Coherence)springSessionCoherenceInstance.getIfAvailable();
        if (coherenceInstanceToUse == null) {
            coherenceInstanceToUse = (Coherence)coherenceInstance.getObject();
        }
        this.coherence = coherenceInstanceToUse;
    }

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        String coherenceSessionNameValue;
        Map attributeMap = importMetadata.getAnnotationAttributes(EnableCoherenceHttpSession.class.getName());
        AnnotationAttributes attributes = AnnotationAttributes.fromMap((Map)attributeMap);
        this.maxInactiveIntervalInSeconds = (Integer)attributes.getNumber("sessionTimeoutInSeconds");
        String sessionMapNameValue = attributes.getString("cache");
        if (StringUtils.hasText((String)sessionMapNameValue)) {
            this.sessionMapName = sessionMapNameValue;
        }
        if (StringUtils.hasText((String)(coherenceSessionNameValue = attributes.getString("session")))) {
            this.coherenceSessionName = coherenceSessionNameValue;
        }
        this.flushMode = (FlushMode)attributes.getEnum("flushMode");
        this.saveMode = (SaveMode)attributes.getEnum("saveMode");
    }

    @Autowired(required=false)
    public void setIndexResolver(IndexResolver<Session> indexResolver) {
        this.indexResolver = indexResolver;
    }

    @Autowired(required=false)
    public void setSessionRepositoryCustomizer(ObjectProvider<SessionRepositoryCustomizer<CoherenceIndexedSessionRepository>> sessionRepositoryCustomizers) {
        this.sessionRepositoryCustomizers = sessionRepositoryCustomizers.orderedStream().collect(Collectors.toList());
    }

    public void setMaxInactiveIntervalInSeconds(int maxInactiveIntervalInSeconds) {
        this.maxInactiveIntervalInSeconds = maxInactiveIntervalInSeconds;
    }

    public void setSessionMapName(String sessionMapName) {
        this.sessionMapName = sessionMapName;
    }

    public void setFlushMode(FlushMode flushMode) {
        this.flushMode = flushMode;
    }

    public void setSaveMode(SaveMode saveMode) {
        this.saveMode = saveMode;
    }

    private CoherenceIndexedSessionRepository createCoherenceIndexedSessionRepository() {
        if (logger.isInfoEnabled()) {
            logger.info((Object)"Creating CoherenceIndexedSessionRepository...");
        }
        com.tangosol.net.Session coherenceSession = StringUtils.hasText((String)this.coherenceSessionName) ? this.coherence.getSession(this.coherenceSessionName) : this.coherence.getSession();
        CoherenceIndexedSessionRepository sessionRepository = new CoherenceIndexedSessionRepository(coherenceSession);
        if (this.indexResolver != null) {
            sessionRepository.setIndexResolver(this.indexResolver);
        }
        if (StringUtils.hasText((String)this.sessionMapName)) {
            sessionRepository.setSessionMapName(this.sessionMapName);
        }
        sessionRepository.setDefaultMaxInactiveInterval(Duration.ofSeconds(this.maxInactiveIntervalInSeconds.intValue()));
        sessionRepository.setFlushMode(this.flushMode);
        sessionRepository.setSaveMode(this.saveMode);
        this.sessionRepositoryCustomizers.forEach(sessionRepositoryCustomizer -> sessionRepositoryCustomizer.customize((SessionRepository)sessionRepository));
        return sessionRepository;
    }
}

