/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.spring.session;

import com.tangosol.coherence.memcached.server.MemcachedHelper;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.processor.AbstractProcessor;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import org.springframework.session.MapSession;

public class SessionUpdateEntryProcessor
extends AbstractProcessor<String, MapSession, Object>
implements PortableObject {
    private Instant lastAccessedTime;
    private Duration maxInactiveInterval;
    private Duration defaultMaxInactiveInterval;
    private Map<String, Object> delta;

    public Object process(InvocableMap.Entry<String, MapSession> entry) {
        MapSession mapSession = (MapSession)entry.getValue();
        if (mapSession == null) {
            return Boolean.FALSE;
        }
        if (this.lastAccessedTime != null) {
            mapSession.setLastAccessedTime(this.lastAccessedTime);
        }
        BinaryEntry binaryEntry = MemcachedHelper.getBinaryEntry(entry);
        if (this.maxInactiveInterval != null) {
            mapSession.setMaxInactiveInterval(this.maxInactiveInterval);
        }
        if (this.delta != null) {
            for (Map.Entry<String, Object> attribute : this.delta.entrySet()) {
                if (attribute.getValue() != null) {
                    mapSession.setAttribute(attribute.getKey(), attribute.getValue());
                    continue;
                }
                mapSession.removeAttribute(attribute.getKey());
            }
        }
        entry.setValue((Object)mapSession, false);
        if (this.maxInactiveInterval != null && !this.maxInactiveInterval.isNegative()) {
            binaryEntry.expire(this.maxInactiveInterval.toMillis());
        } else if (this.defaultMaxInactiveInterval != null && !this.defaultMaxInactiveInterval.isNegative()) {
            binaryEntry.expire(this.defaultMaxInactiveInterval.toMillis());
        }
        return Boolean.TRUE;
    }

    public static BinaryEntry getBinaryEntry(InvocableMap.Entry entry) {
        try {
            return (BinaryEntry)entry;
        }
        catch (ClassCastException cce) {
            throw new RuntimeException("The MemcachedAcceptor is only supported by the DistributedCache");
        }
    }

    void setLastAccessedTime(Instant lastAccessedTime) {
        this.lastAccessedTime = lastAccessedTime;
    }

    void setMaxInactiveInterval(Duration maxInactiveInterval) {
        this.maxInactiveInterval = maxInactiveInterval;
    }

    public void setDefaultMaxInactiveInterval(Duration defaultMaxInactiveInterval) {
        this.defaultMaxInactiveInterval = defaultMaxInactiveInterval;
    }

    void setDelta(Map<String, Object> delta) {
        this.delta = delta;
    }

    public void readExternal(PofReader pofReader) throws IOException {
        this.lastAccessedTime = (Instant)pofReader.readObject(0);
        this.maxInactiveInterval = (Duration)pofReader.readObject(1);
        this.delta = pofReader.readMap(2, new HashMap());
        this.defaultMaxInactiveInterval = (Duration)pofReader.readObject(3);
    }

    public void writeExternal(PofWriter pofWriter) throws IOException {
        pofWriter.writeObject(0, (Object)this.lastAccessedTime);
        pofWriter.writeObject(1, (Object)this.maxInactiveInterval);
        pofWriter.writeMap(2, this.delta);
        pofWriter.writeObject(3, (Object)this.defaultMaxInactiveInterval);
    }
}

