/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.spring.session;

import com.oracle.coherence.spring.session.CoherenceIndexedSessionRepository;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.session.FindByIndexNameSessionRepository;
import org.springframework.session.FlushMode;
import org.springframework.session.MapSession;
import org.springframework.session.SaveMode;
import org.springframework.session.Session;

final class CoherenceSpringSession
implements Session {
    private final CoherenceIndexedSessionRepository coherenceIndexedSessionRepository;
    private final MapSession delegate;
    private boolean isNew;
    private boolean sessionIdChanged;
    private boolean lastAccessedTimeChanged;
    private boolean maxInactiveIntervalChanged;
    private String originalId;
    private final Map<String, Object> delta = new HashMap<String, Object>();

    CoherenceSpringSession(CoherenceIndexedSessionRepository coherenceIndexedSessionRepository, MapSession cached, boolean isNew) {
        this.coherenceIndexedSessionRepository = coherenceIndexedSessionRepository;
        this.delegate = cached;
        this.isNew = isNew;
        this.originalId = cached.getId();
        if (this.isNew || coherenceIndexedSessionRepository.getSaveMode() == SaveMode.ALWAYS) {
            this.getAttributeNames().forEach(attributeName -> this.delta.put((String)attributeName, cached.getAttribute(attributeName)));
        }
    }

    public void setLastAccessedTime(Instant lastAccessedTime) {
        this.delegate.setLastAccessedTime(lastAccessedTime);
        this.lastAccessedTimeChanged = true;
        this.flushIfNeeded();
    }

    public boolean isExpired() {
        return this.delegate.isExpired();
    }

    public Instant getCreationTime() {
        return this.delegate.getCreationTime();
    }

    public String getId() {
        return this.delegate.getId();
    }

    public String changeSessionId() {
        String newSessionId = this.delegate.changeSessionId();
        this.sessionIdChanged = true;
        return newSessionId;
    }

    public Instant getLastAccessedTime() {
        return this.delegate.getLastAccessedTime();
    }

    public void setMaxInactiveInterval(Duration interval) {
        this.delegate.setMaxInactiveInterval(interval);
        this.maxInactiveIntervalChanged = true;
        this.flushIfNeeded();
    }

    public Duration getMaxInactiveInterval() {
        return this.delegate.getMaxInactiveInterval();
    }

    boolean isNew() {
        return this.isNew;
    }

    boolean isSessionIdChanged() {
        return this.sessionIdChanged;
    }

    boolean isLastAccessedTimeChanged() {
        return this.lastAccessedTimeChanged;
    }

    boolean isMaxInactiveIntervalChanged() {
        return this.maxInactiveIntervalChanged;
    }

    String getOriginalId() {
        return this.originalId;
    }

    Map<String, Object> getDelta() {
        return this.delta;
    }

    public synchronized <T> T getAttribute(String attributeName) {
        Object attributeValue = this.delegate.getAttribute(attributeName);
        if (attributeValue != null && this.coherenceIndexedSessionRepository.getSaveMode().equals((Object)SaveMode.ON_GET_ATTRIBUTE)) {
            this.delta.put(attributeName, attributeValue);
        }
        return (T)attributeValue;
    }

    public Set<String> getAttributeNames() {
        return this.delegate.getAttributeNames();
    }

    public void setAttribute(String attributeName, Object attributeValue) {
        this.delegate.setAttribute(attributeName, attributeValue);
        this.delta.put(attributeName, attributeValue);
        if ("SPRING_SECURITY_CONTEXT".equals(attributeName)) {
            Map indexes = this.coherenceIndexedSessionRepository.getIndexResolver().resolveIndexesFor((Session)this);
            String principal = attributeValue != null ? (String)indexes.get(FindByIndexNameSessionRepository.PRINCIPAL_NAME_INDEX_NAME) : null;
            this.delegate.setAttribute(FindByIndexNameSessionRepository.PRINCIPAL_NAME_INDEX_NAME, (Object)principal);
        }
        this.flushIfNeeded();
    }

    public void removeAttribute(String attributeName) {
        this.setAttribute(attributeName, null);
    }

    MapSession getDelegate() {
        return this.delegate;
    }

    void setOriginalId(String originalId) {
        this.originalId = originalId;
    }

    boolean hasChanges() {
        return this.lastAccessedTimeChanged || this.maxInactiveIntervalChanged || !this.delta.isEmpty();
    }

    void clearChangeFlags() {
        this.isNew = false;
        this.lastAccessedTimeChanged = false;
        this.sessionIdChanged = false;
        this.maxInactiveIntervalChanged = false;
        this.delta.clear();
    }

    void flushIfNeeded() {
        if (this.coherenceIndexedSessionRepository.getFlushMode() == FlushMode.IMMEDIATE) {
            this.coherenceIndexedSessionRepository.save(this);
        }
    }
}

