/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.spring.session;

import com.oracle.coherence.spring.session.CoherenceSpringSession;
import com.oracle.coherence.spring.session.SessionUpdateEntryProcessor;
import com.oracle.coherence.spring.session.events.CoherenceSessionCreatedEventHandler;
import com.oracle.coherence.spring.session.events.SessionRemovedMapListener;
import com.oracle.coherence.spring.session.support.PrincipalNameExtractor;
import com.tangosol.net.NamedCache;
import com.tangosol.net.NamedMap;
import com.tangosol.net.events.EventInterceptor;
import com.tangosol.net.events.internal.NamedEventInterceptor;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.MapListener;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.filter.EqualsFilter;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.session.DelegatingIndexResolver;
import org.springframework.session.FindByIndexNameSessionRepository;
import org.springframework.session.FlushMode;
import org.springframework.session.IndexResolver;
import org.springframework.session.MapSession;
import org.springframework.session.PrincipalNameIndexResolver;
import org.springframework.session.SaveMode;
import org.springframework.session.Session;
import org.springframework.util.Assert;

public class CoherenceIndexedSessionRepository
implements FindByIndexNameSessionRepository<CoherenceSpringSession>,
ApplicationEventPublisherAware {
    public static final String DEFAULT_SESSION_MAP_NAME = "spring:session:sessions";
    public static final String PRINCIPAL_NAME_ATTRIBUTE = "principalName";
    static final String SPRING_SECURITY_CONTEXT = "SPRING_SECURITY_CONTEXT";
    private static final Log logger = LogFactory.getLog(CoherenceIndexedSessionRepository.class);
    private final com.tangosol.net.Session coherenceSession;
    private ApplicationEventPublisher eventPublisher;
    private Duration defaultMaxInactiveInterval;
    private IndexResolver<Session> indexResolver = new DelegatingIndexResolver(new IndexResolver[]{new PrincipalNameIndexResolver()});
    private String sessionMapName = "spring:session:sessions";
    private FlushMode flushMode = FlushMode.ON_SAVE;
    private SaveMode saveMode = SaveMode.ON_SET_ATTRIBUTE;
    private NamedCache<String, MapSession> sessionCache;

    public CoherenceIndexedSessionRepository(com.tangosol.net.Session coherenceSession) {
        Assert.notNull((Object)coherenceSession, (String)"CoherenceSession must not be null");
        this.coherenceSession = coherenceSession;
    }

    @PostConstruct
    public void init() {
        this.sessionCache = this.coherenceSession.getCache(this.sessionMapName, new NamedMap.Option[0]);
        CoherenceSessionCreatedEventHandler coherenceSessionEventHandler = new CoherenceSessionCreatedEventHandler(this.eventPublisher);
        SessionRemovedMapListener sessionRemovedMapListener = new SessionRemovedMapListener(this.eventPublisher);
        coherenceSessionEventHandler.setScopeName(this.coherenceSession.getScopeName());
        coherenceSessionEventHandler.setCacheName(this.sessionCache.getCacheName());
        this.sessionCache.addMapListener((MapListener)sessionRemovedMapListener);
        NamedEventInterceptor interceptor = new NamedEventInterceptor(CoherenceSessionCreatedEventHandler.class.getName(), (EventInterceptor)coherenceSessionEventHandler);
        this.coherenceSession.getInterceptorRegistry().registerEventInterceptor((EventInterceptor)interceptor);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("CoherenceIndexedSessionRepository initialized with [Scope: %s; cache: %s; defaultMaxInactiveInterval: %ssec]", this.coherenceSession.getScopeName(), this.sessionCache.getCacheName(), this.defaultMaxInactiveInterval));
        }
    }

    @PreDestroy
    public void close() {
        this.sessionCache.close();
    }

    public void setDefaultMaxInactiveInterval(Duration defaultMaxInactiveInterval) {
        Assert.notNull((Object)defaultMaxInactiveInterval, (String)"defaultMaxInactiveInterval must not be null");
        Assert.isTrue((defaultMaxInactiveInterval.toMillis() >= 0L ? 1 : 0) != 0, (String)"defaultMaxInactiveInterval must not be negative");
        this.defaultMaxInactiveInterval = defaultMaxInactiveInterval;
    }

    public void setIndexResolver(IndexResolver<Session> indexResolver) {
        Assert.notNull(indexResolver, (String)"indexResolver cannot be null");
        this.indexResolver = indexResolver;
    }

    public void setSessionMapName(String sessionMapName) {
        Assert.hasText((String)sessionMapName, (String)"Map name must not be empty");
        this.sessionMapName = sessionMapName;
    }

    public void setFlushMode(FlushMode flushMode) {
        Assert.notNull((Object)flushMode, (String)"flushMode must not be null");
        this.flushMode = flushMode;
    }

    public void setSaveMode(SaveMode saveMode) {
        Assert.notNull((Object)saveMode, (String)"saveMode must not be null");
        this.saveMode = saveMode;
    }

    public CoherenceSpringSession createSession() {
        MapSession cached = new MapSession();
        if (this.defaultMaxInactiveInterval != null) {
            cached.setMaxInactiveInterval(this.defaultMaxInactiveInterval);
        }
        CoherenceSpringSession session = new CoherenceSpringSession(this, cached, true);
        session.flushIfNeeded();
        return session;
    }

    public void save(CoherenceSpringSession session) {
        boolean expireCacheEntry;
        long maxInactiveIntervalMillis = session.getMaxInactiveInterval().toMillis();
        boolean bl = expireCacheEntry = maxInactiveIntervalMillis > 0L;
        if (session.isNew()) {
            if (expireCacheEntry) {
                this.sessionCache.put((Object)session.getId(), (Object)session.getDelegate(), maxInactiveIntervalMillis);
            } else {
                this.sessionCache.put((Object)session.getId(), (Object)session.getDelegate());
            }
        } else if (session.isSessionIdChanged()) {
            this.sessionCache.remove((Object)session.getOriginalId());
            session.setOriginalId(session.getId());
            if (expireCacheEntry) {
                this.sessionCache.put((Object)session.getId(), (Object)session.getDelegate(), maxInactiveIntervalMillis);
            } else {
                this.sessionCache.put((Object)session.getId(), (Object)session.getDelegate());
            }
        } else if (session.hasChanges()) {
            SessionUpdateEntryProcessor entryProcessor = new SessionUpdateEntryProcessor();
            entryProcessor.setDefaultMaxInactiveInterval(this.defaultMaxInactiveInterval);
            if (session.isLastAccessedTimeChanged()) {
                entryProcessor.setLastAccessedTime(session.getLastAccessedTime());
            }
            if (session.isMaxInactiveIntervalChanged()) {
                entryProcessor.setMaxInactiveInterval(session.getMaxInactiveInterval());
            }
            if (!session.getDelta().isEmpty()) {
                entryProcessor.setDelta(new HashMap<String, Object>(session.getDelta()));
            }
            this.sessionCache.invoke((Object)session.getId(), (InvocableMap.EntryProcessor)entryProcessor);
        }
        session.clearChangeFlags();
    }

    public CoherenceSpringSession findById(String id) {
        MapSession saved = (MapSession)this.sessionCache.get((Object)id);
        if (saved == null) {
            return null;
        }
        if (saved.isExpired()) {
            this.deleteById(saved.getId());
            return null;
        }
        return new CoherenceSpringSession(this, saved, false);
    }

    public void deleteById(String id) {
        this.sessionCache.remove((Object)id);
    }

    public Map<String, CoherenceSpringSession> findByIndexNameAndIndexValue(String indexName, String indexValue) {
        if (!PRINCIPAL_NAME_INDEX_NAME.equals(indexName)) {
            return Collections.emptyMap();
        }
        EqualsFilter filter = new EqualsFilter((ValueExtractor)new PrincipalNameExtractor(), (Object)indexValue);
        Set sessions = this.sessionCache.entrySet((Filter)filter);
        HashMap<String, CoherenceSpringSession> sessionMap = new HashMap<String, CoherenceSpringSession>(sessions.size());
        for (Map.Entry session : sessions) {
            sessionMap.put(((MapSession)session.getValue()).getId(), new CoherenceSpringSession(this, (MapSession)session.getValue(), false));
        }
        return sessionMap;
    }

    public FlushMode getFlushMode() {
        return this.flushMode;
    }

    public SaveMode getSaveMode() {
        return this.saveMode;
    }

    public IndexResolver<Session> getIndexResolver() {
        return this.indexResolver;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        Assert.notNull((Object)applicationEventPublisher, (String)"ApplicationEventPublisher cannot be null");
        this.eventPublisher = applicationEventPublisher;
    }
}

