/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.patterns.processing.taskprocessor;

import com.oracle.coherence.common.identifiers.Identifier;
import com.oracle.coherence.common.util.ObjectChangeCallback;
import com.oracle.coherence.common.util.ObjectProxyFactory;
import com.oracle.coherence.patterns.processing.SubmissionConfiguration;
import com.oracle.coherence.patterns.processing.SubmissionState;
import com.oracle.coherence.patterns.processing.internal.Submission;
import com.oracle.coherence.patterns.processing.internal.SubmissionContent;
import com.oracle.coherence.patterns.processing.internal.SubmissionKeyPair;
import com.oracle.coherence.patterns.processing.internal.SubmissionResult;
import com.oracle.coherence.patterns.processing.internal.task.TaskProcessorMediator;
import com.oracle.coherence.patterns.processing.internal.task.TaskProcessorMediatorKey;
import com.oracle.coherence.patterns.processing.task.ResumableTask;
import com.oracle.coherence.patterns.processing.task.TaskExecutionEnvironment;
import com.oracle.coherence.patterns.processing.task.Yield;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TaskRunner
implements Runnable,
TaskExecutionEnvironment,
ObjectChangeCallback<SubmissionResult> {
    private static final Logger logger = Logger.getLogger(TaskRunner.class.getName());
    private final TaskProcessorMediator taskProcessorMediator;
    private final SubmissionKeyPair pendingTaskKeyPair;
    private boolean m_bIsResuming;
    private final Submission submission;
    private SubmissionResult submissionResult;
    private final ObjectProxyFactory<SubmissionResult> submissionResultProxyFactory;
    private Identifier submissionResultIdentifier;
    private volatile Thread executionThread;
    private volatile transient boolean isCancelled;
    private TaskProcessorMediatorKey taskProcessorMediatorKey;

    public TaskRunner(SubmissionKeyPair pendingTaskKeyPair, TaskProcessorMediator taskProcessorMediator, Submission submission, Identifier submissionResultIdentifier, ObjectProxyFactory<SubmissionResult> submissionResultProxyFactory, TaskProcessorMediatorKey taskProcessorMediatorKey) {
        this.pendingTaskKeyPair = pendingTaskKeyPair;
        this.taskProcessorMediator = taskProcessorMediator;
        this.submissionResultProxyFactory = submissionResultProxyFactory;
        this.submissionResultIdentifier = submissionResultIdentifier;
        this.submission = submission;
        this.submissionResult = null;
        this.m_bIsResuming = false;
        this.isCancelled = false;
        this.taskProcessorMediatorKey = taskProcessorMediatorKey;
    }

    @Override
    public Object loadCheckpoint() {
        return this.submissionResult.getResult();
    }

    @Override
    public void reportProgress(Object oProgress) {
        this.submissionResult.setProgress(oProgress);
    }

    @Override
    public void saveCheckpoint(Object intermediateState) {
        this.submissionResult.setResult(intermediateState);
    }

    @Override
    public boolean isResuming() {
        return this.m_bIsResuming;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.submissionResult = (SubmissionResult)this.submissionResultProxyFactory.getProxy((Object)this.submissionResultIdentifier);
        try {
            this.executionThread = Thread.currentThread();
            this.submissionResultProxyFactory.registerChangeCallback((Object)this.submissionResult, (ObjectChangeCallback)this);
            ResumableTask taskToExecute = null;
            SubmissionContent submissionContent = this.submission.getContent();
            if (submissionContent.getPayload() instanceof ResumableTask) {
                taskToExecute = (ResumableTask)submissionContent.getPayload();
            }
            if (taskToExecute == null) {
                throw new UnsupportedOperationException(String.format("Can't execute %s as it's not a Task", this.pendingTaskKeyPair));
            }
            try {
                if (this.submissionResult.isResuming()) {
                    this.m_bIsResuming = true;
                }
                this.doExecuteTask(this.submissionResult, this.submission, taskToExecute, submissionContent.getSubmissionConfiguration());
            }
            catch (Exception exception) {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.log(Level.WARNING, "TaskRunner - Failed to process {0} due to:\n{1}", new Object[]{this.pendingTaskKeyPair, exception});
                }
                this.setProcessingFailed(this.submissionResult, exception);
            }
        }
        finally {
            this.submissionResultProxyFactory.unregisterChangeCallback((Object)this.submissionResult, (ObjectChangeCallback)this);
        }
    }

    private void checkResult(SubmissionResult submissionResult, Submission submission, SubmissionConfiguration oRequestData, Object oResult, long executionDuration) {
        if (!this.isCancelled) {
            if (oResult instanceof Yield) {
                Yield yieldresult = (Yield)oResult;
                this.yield(submissionResult, submission, yieldresult.getIntermediateState(), yieldresult.getDelay(), executionDuration);
            } else if (this.setProcessingSucceeded(submissionResult, oResult, executionDuration)) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "Executed {0} to produce {1}", new Object[]{this.pendingTaskKeyPair, oResult});
                }
            } else if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "Failed to set processing to executed for task {0}", this.pendingTaskKeyPair);
            }
        }
    }

    private boolean doExecuteTask(SubmissionResult submissionResult, Submission submission, ResumableTask task, SubmissionConfiguration configuration) {
        if (this.setProcessingStarted(submissionResult)) {
            long startTime = System.currentTimeMillis();
            Object oResult = task.run(this);
            if (Thread.interrupted() && logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "The Task {0} was cancelled during execution", new Object[]{this.pendingTaskKeyPair});
            }
            long executionDuration = System.currentTimeMillis() - startTime;
            this.checkResult(submissionResult, submission, configuration, oResult, executionDuration);
            return true;
        }
        return false;
    }

    private boolean setProcessingFailed(SubmissionResult submissionResult, Exception oException) {
        this.taskProcessorMediator.taskDone(this.pendingTaskKeyPair.getKey(), 0L, false);
        return submissionResult.processingFailed(oException);
    }

    private boolean setProcessingStarted(SubmissionResult submissionResult) {
        return submissionResult.processingStarted(this.taskProcessorMediatorKey);
    }

    private boolean setProcessingSucceeded(SubmissionResult submissionResult, Object oResult, long executionDuration) {
        this.taskProcessorMediator.taskDone(this.pendingTaskKeyPair.getKey(), executionDuration, false);
        Boolean result = submissionResult.processingSucceeded(oResult);
        return result;
    }

    private boolean yield(SubmissionResult submissionResult, Submission submission, Object intermediateState, long delay, long executionDuration) {
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Yielding {0}", this.pendingTaskKeyPair);
        }
        this.taskProcessorMediator.taskDone(this.pendingTaskKeyPair.getKey(), executionDuration, true);
        boolean result = submissionResult.suspendExecution(intermediateState);
        submission.reDispatch(delay);
        return result;
    }

    public void objectChanged(SubmissionResult object) {
        if (object != null && object.getSubmissionState() == SubmissionState.CANCELLED) {
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "Received change of state to CANCELLED - interrupting execution of {0}", new Object[0]);
            }
            this.interruptExecution();
        }
    }

    public void interruptExecution() {
        this.isCancelled = true;
        if (this.executionThread != null) {
            this.executionThread.interrupt();
        }
    }

    public void objectCreated(SubmissionResult object) {
    }

    public void objectDeleted(Object key) {
    }
}

