/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.patterns.processing.taskprocessor;

import com.oracle.coherence.common.leasing.Lease;
import com.oracle.coherence.common.processors.InvokeMethodProcessor;
import com.oracle.coherence.common.threading.ExecutorServiceFactory;
import com.oracle.coherence.common.threading.ThreadFactories;
import com.oracle.coherence.patterns.processing.dispatchers.task.DefaultTaskDispatcher;
import com.oracle.coherence.patterns.processing.internal.Environment;
import com.oracle.coherence.patterns.processing.internal.task.TaskProcessorMediatorKey;
import com.oracle.coherence.patterns.processing.taskprocessor.ClientLeaseMaintainer;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.NamedCache;
import com.tangosol.util.InvocableMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultClientLeaseMaintainer
implements ClientLeaseMaintainer {
    private static final long LEASE_DURATION = 125000L;
    private static Logger logger = Logger.getLogger(DefaultClientLeaseMaintainer.class.getName());
    private ScheduledExecutorService executorService;
    private ConcurrentHashMap<TaskProcessorMediatorKey, Lease> leases;
    private long leaseValidityCheckingDelay;
    private Environment environment;
    private NamedCache taskProcessorMediatorCache;

    public DefaultClientLeaseMaintainer(Environment environment, long leaseValidityCheckingDelay) {
        this.environment = environment;
        this.leases = new ConcurrentHashMap();
        this.leaseValidityCheckingDelay = leaseValidityCheckingDelay;
        DefaultTaskDispatcher.setClientLeaseMaintainer(this);
    }

    public ConcurrentHashMap<TaskProcessorMediatorKey, Lease> getLeases() {
        return this.leases;
    }

    @Override
    public void addLease(TaskProcessorMediatorKey taskProcessorKey, Lease lease) {
        this.leases.put(taskProcessorKey, lease);
    }

    public void onDependenciesSatisfied(Environment environment) {
        this.taskProcessorMediatorCache = CacheFactory.getCache((String)"coherence.patterns.processing.taskprocessormediator");
        this.executorService = ExecutorServiceFactory.newSingleThreadScheduledExecutor((ThreadFactory)ThreadFactories.newThreadFactory((boolean)true, (String)"ClientLeaseCoordinator", null));
        this.executorService.scheduleAtFixedRate(new LeaseExtender(), this.leaseValidityCheckingDelay, this.leaseValidityCheckingDelay, TimeUnit.MILLISECONDS);
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Started ClientLeaseMaintainer - checking lease validity every {0} ms. Extending leases with {1}", new Object[]{this.leaseValidityCheckingDelay, 125000L});
        }
    }

    public void onDependenciesViolated(Environment environment) {
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "Shutting down ClientLeaseMaintainer");
        }
        this.executorService.shutdownNow();
    }

    @Override
    public void removeLease(TaskProcessorMediatorKey taskProcessorKey, Lease lease) {
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Removing lease for {0}", taskProcessorKey);
        }
        this.leases.remove(taskProcessorKey);
    }

    private class LeaseExtender
    implements Runnable {
        private LeaseExtender() {
        }

        @Override
        public void run() {
            block5: {
                try {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.log(Level.FINER, "LeaseExtender running");
                    }
                    ConcurrentHashMap<TaskProcessorMediatorKey, Lease> leases = DefaultClientLeaseMaintainer.this.getLeases();
                    for (TaskProcessorMediatorKey key : leases.keySet()) {
                        if (logger.isLoggable(Level.FINER)) {
                            logger.log(Level.FINER, "Extending TaskProcessorLease for {0}", key);
                        }
                        DefaultClientLeaseMaintainer.this.taskProcessorMediatorCache.invoke((Object)key, (InvocableMap.EntryProcessor)new InvokeMethodProcessor("extendTaskProcessorLease", new Object[]{125000L}));
                    }
                }
                catch (Exception e) {
                    if (!logger.isLoggable(Level.SEVERE)) break block5;
                    logger.log(Level.SEVERE, "Exception caught during lease extension", e);
                }
            }
        }
    }
}

