/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.patterns.processing.task;

import com.oracle.coherence.common.util.ObjectProxyFactory;
import com.oracle.coherence.patterns.processing.internal.Submission;
import com.oracle.coherence.patterns.processing.internal.SubmissionKeyPair;
import com.oracle.coherence.patterns.processing.internal.SubmissionResult;
import com.oracle.coherence.patterns.processing.internal.task.TaskProcessorMediator;
import com.oracle.coherence.patterns.processing.internal.task.TaskProcessorMediatorKey;
import com.oracle.coherence.patterns.processing.task.TaskProcessor;
import com.oracle.coherence.patterns.processing.taskprocessor.ClientLeaseMaintainer;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.Base;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import com.tangosol.util.MultiplexingMapListener;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractTaskProcessor
implements TaskProcessor,
ExternalizableLite,
PortableObject {
    private static Logger logger = Logger.getLogger(AbstractTaskProcessor.class.getName());
    private static int LEASE_DURATION = 60000;
    private TaskProcessorMediatorKey taskProcessorKey;
    private String displayName;
    private transient ObjectProxyFactory<TaskProcessorMediator> taskProcessorMediatorProxyFactory;
    private transient MapListener taskProcessorMediatorListener;
    private transient ObjectProxyFactory<Submission> submissionProxyFactory;
    private transient ObjectProxyFactory<SubmissionResult> submissionResultProxyFactory;
    private transient TaskProcessorMediator taskProcessorMediator;
    private transient ClientLeaseMaintainer clientLeaseMaintainer;
    private volatile transient boolean isStarted;

    public AbstractTaskProcessor() {
    }

    public AbstractTaskProcessor(TaskProcessorMediatorKey taskProcessorKey, String displayName) {
        this.displayName = displayName;
        this.taskProcessorKey = taskProcessorKey;
        this.isStarted = false;
    }

    public abstract void executeTask(SubmissionKeyPair var1);

    public String getDisplayName() {
        return this.displayName;
    }

    public ObjectProxyFactory<TaskProcessorMediator> getTaskProcessorMediatorProxyFactory() {
        return this.taskProcessorMediatorProxyFactory;
    }

    public ObjectProxyFactory<Submission> getSubmissionProxyFactory() {
        return this.submissionProxyFactory;
    }

    public ObjectProxyFactory<SubmissionResult> getSubmissionResultProxyFactory() {
        return this.submissionResultProxyFactory;
    }

    public TaskProcessorMediator getTaskProcessorMediator() {
        return this.taskProcessorMediator;
    }

    public void setTaskProcessorKey(TaskProcessorMediatorKey taskProcessorKey) {
        this.taskProcessorKey = taskProcessorKey;
    }

    @Override
    public TaskProcessorMediatorKey getTaskProcessorKey() {
        return this.taskProcessorKey;
    }

    @Override
    public String getName() {
        return this.displayName;
    }

    public String toString() {
        String result = "TaskProcessor name:" + this.displayName;
        return result;
    }

    @Override
    public void onStartup(TaskProcessorMediator taskProcessorMediator, TaskProcessorMediatorKey key, ObjectProxyFactory<Submission> submissionProxyFactory, ObjectProxyFactory<SubmissionResult> submissionResultProxyFactory, ObjectProxyFactory<TaskProcessorMediator> taskProcessorMediatorProxyFactory, ClientLeaseMaintainer clientLeaseMaintainer) {
        this.taskProcessorMediator = taskProcessorMediator;
        this.setTaskProcessorKey(key);
        this.taskProcessorMediatorProxyFactory = taskProcessorMediatorProxyFactory;
        this.submissionProxyFactory = submissionProxyFactory;
        this.submissionResultProxyFactory = submissionResultProxyFactory;
        this.clientLeaseMaintainer = clientLeaseMaintainer;
        try {
            clientLeaseMaintainer.addLease(this.getTaskProcessorKey(), taskProcessorMediator.getTaskProcessorLease(LEASE_DURATION));
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "TaskProcessor unable to add lease", e);
            throw Base.ensureRuntimeException((Throwable)e);
        }
        this.initializeTaskProcessorMediatorListener();
        this.isStarted = true;
        this.drainQueue();
    }

    private void initializeTaskProcessorMediatorListener() {
        this.taskProcessorMediatorListener = new MultiplexingMapListener(){

            protected void onMapEvent(MapEvent mapEvent) {
                if (mapEvent.getId() == 1) {
                    if (AbstractTaskProcessor.this.isStarted) {
                        AbstractTaskProcessor.this.dequeueTaskLocally();
                    }
                } else if (mapEvent.getId() == 2 && AbstractTaskProcessor.this.isStarted) {
                    AbstractTaskProcessor.this.dequeueTaskLocally();
                }
            }
        };
        this.taskProcessorMediatorProxyFactory.getNamedCache().addMapListener(this.taskProcessorMediatorListener, (Object)this.getTaskProcessorKey(), true);
    }

    private void dequeueTaskLocally() {
        if (this.isStarted) {
            SubmissionKeyPair taskInProgress = this.taskProcessorMediator.dequeueTask();
            this.executeTask(taskInProgress);
        }
    }

    private void drainQueue() {
        List<SubmissionKeyPair> toBeExecuted;
        if (this.isStarted && (toBeExecuted = this.taskProcessorMediator.drainQueueToBeExecuted()) != null) {
            for (SubmissionKeyPair taskInProgress : toBeExecuted) {
                this.executeTask(taskInProgress);
            }
        }
    }

    @Override
    public void onShutdown() {
        this.isStarted = false;
    }

    public void readExternal(DataInput in) throws IOException {
        this.taskProcessorKey = (TaskProcessorMediatorKey)ExternalizableHelper.readObject((DataInput)in);
        this.displayName = ExternalizableHelper.readSafeUTF((DataInput)in);
    }

    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject((DataOutput)out, (Object)this.taskProcessorKey);
        ExternalizableHelper.writeSafeUTF((DataOutput)out, (String)this.displayName);
    }

    public void readExternal(PofReader reader) throws IOException {
        this.taskProcessorKey = (TaskProcessorMediatorKey)reader.readObject(0);
        this.displayName = reader.readString(1);
    }

    public void writeExternal(PofWriter writer) throws IOException {
        writer.writeObject(0, (Object)this.taskProcessorKey);
        writer.writeString(1, this.displayName);
    }
}

